/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.NamespaceLabelFilter;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.labels.PermittedLabelView;
import com.atlassian.confluence.labels.SpecialLabelFilter;
import com.atlassian.confluence.labels.VisibleLabelFilter;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.filter.Filter;
import com.atlassian.core.util.filter.FilterChain;
import com.atlassian.core.util.filter.ListFilter;
import com.atlassian.user.User;
import java.util.List;

public class LabelPermissionSupport {
    public static boolean userCanEditLabels(Labelable object, PermissionManager permissionManager) {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (GeneralUtil.isSuperUser(user)) {
            return true;
        }
        return permissionManager.hasPermission(user, Permission.EDIT, object) || user != null && permissionManager.hasPermission(user, Permission.VIEW, object);
    }

    public static boolean userCanEditLabel(ParsedLabelName ref, Labelable object, PermissionManager permissionManager) {
        if (object instanceof PermittedLabelView) {
            return LabelPermissionSupport.userCanEditLabel(ref, ((PermittedLabelView)object).getDelegate(), permissionManager);
        }
        if (!LabelPermissionSupport.userCanViewObject(object, permissionManager)) {
            return false;
        }
        User user = AuthenticatedUserThreadLocal.getUser();
        return !(ref.getOwner() == null ? !permissionManager.hasPermission(user, Permission.EDIT, object) : user == null || !permissionManager.hasPermission(user, Permission.VIEW, object));
    }

    public static boolean userCanEditLabel(Label label, Labelable object, PermissionManager permissionManager) {
        if (object instanceof PermittedLabelView) {
            return LabelPermissionSupport.userCanEditLabel(label, ((PermittedLabelView)object).getDelegate(), permissionManager);
        }
        if (!LabelPermissionSupport.userCanViewObject(object, permissionManager)) {
            return false;
        }
        User user = AuthenticatedUserThreadLocal.getUser();
        return !(Namespace.isGlobal(label) ? !permissionManager.hasPermission(user, Permission.EDIT, object) : Namespace.isPersonal(label) && !permissionManager.hasPermission(user, Permission.VIEW, object));
    }

    public static boolean userCanViewObject(Labelable object, PermissionManager permissionManager) {
        if (object == null) {
            return false;
        }
        if (object instanceof PermittedLabelView) {
            return LabelPermissionSupport.userCanViewObject(((PermittedLabelView)object).getDelegate(), permissionManager);
        }
        User user = AuthenticatedUserThreadLocal.getUser();
        return permissionManager.hasPermission(user, Permission.VIEW, object);
    }

    public static List filterVisibleLabels(List labelList, User user, boolean hideSpecialLables) {
        FilterChain filters = new FilterChain();
        VisibleLabelFilter visibleLabelFilter = user != null ? new VisibleLabelFilter(user.getName()) : new VisibleLabelFilter();
        filters.addFilter((Filter)visibleLabelFilter);
        if (hideSpecialLables) {
            filters.addFilter((Filter)new SpecialLabelFilter());
        }
        ListFilter listFilter = new ListFilter((Filter)filters);
        return listFilter.filterList(labelList);
    }

    public static List filterLabelsByNamespace(List labelList, User user, Namespace namespace) {
        FilterChain filters = new FilterChain();
        NamespaceLabelFilter namespaceLabelFilter = user != null ? new NamespaceLabelFilter(namespace, user.getName()) : new NamespaceLabelFilter(namespace);
        filters.addFilter((Filter)namespaceLabelFilter);
        ListFilter listFilter = new ListFilter((Filter)filters);
        return listFilter.filterList(labelList);
    }
}

