/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ParsedLabelName {
    private String owner;
    private String name;
    private String prefix;

    public ParsedLabelName(String name) {
        this(name, null);
    }

    public ParsedLabelName(String name, String owner) {
        this(name, owner, null);
    }

    public ParsedLabelName(String name, String owner, String prefix) {
        this.name = name;
        this.owner = owner;
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isOwnerSpecified() {
        return TextUtils.stringSet((String)this.getOwner());
    }

    public Label addLabel(Labelable labelable, LabelManager labelManager) {
        Label label = this.toLabel();
        labelManager.addLabel((ContentEntityObject)labelable, label);
        return label;
    }

    public Label toLabel() {
        if (TextUtils.stringSet((String)this.owner) && "my:".equals(this.prefix)) {
            return new Label(this.name, Namespace.PERSONAL, this.owner);
        }
        if ("team:".equals(this.prefix)) {
            return new Label(this.name, Namespace.TEAM);
        }
        return new Label(this.name, Namespace.GLOBAL, this.owner);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ParsedLabelName other = (ParsedLabelName)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)other.name).append((Object)this.owner, (Object)other.owner).append((Object)this.prefix, (Object)other.prefix).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(301, 37).append((Object)this.name).append((Object)this.owner).append((Object)this.prefix).toHashCode();
    }
}

