/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.PermittedLabelView;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.util.List;

public class AbstractLabelsForEntityAction
extends ConfluenceActionSupport {
    private ContentEntityManager contentEntityManager;
    private long entityId;
    private String errorMessage;
    private ContentEntityObject entity;
    private Boolean isPermittedToEditLabels;

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public ContentEntityManager getContentEntityManager() {
        return this.contentEntityManager;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    public Labelable getEntity() {
        return new PermittedLabelView(this.getRawEntity(), this.getRemoteUser(), true);
    }

    public ContentEntityObject getRawEntity() {
        if (this.entity == null) {
            this.entity = this.contentEntityManager.getById(this.getEntityId());
        }
        return this.entity;
    }

    protected void setErrorMessage(String message) {
        this.errorMessage = message;
        ServletActionContext.getResponse().setStatus(500);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isPermitted() {
        if (GeneralUtil.isSuperUser(this.getRemoteUser())) {
            return true;
        }
        Space space = null;
        try {
            space = ((SpaceContentEntityObject)this.getRawEntity()).getSpace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.spacePermissionManager.hasPermission(this.getPermissionTypes(), space, this.getRemoteUser());
    }

    protected List getPermissionTypes() {
        List<String> permissionTypes = super.getPermissionTypes();
        if (this.getRemoteUser() == null) {
            this.addPermissionTypeTo("EDITSPACE", permissionTypes);
        }
        return permissionTypes;
    }

    public boolean isPermittedToEditLabels() {
        if (this.isPermittedToEditLabels == null) {
            this.isPermittedToEditLabels = this.permissionManager.hasPermission(this.getRemoteUser(), Permission.EDIT, this.getRawEntity());
        }
        return this.isPermittedToEditLabels;
    }

    public boolean isPersonalLabel(Label label) {
        return Namespace.isPersonal(label) && this.getRemoteUser() != null && TextUtils.noNull((String)label.getOwner()).equals(this.getRemoteUser().getName());
    }
}

