/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels.actions;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.actions.AbstractLabelEntityBean;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.confluence.util.ajax.AjaxResponse;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GenerateAutocompleteLabelsListBean
extends AbstractLabelEntityBean {
    private PageManager pageManager;
    private LabelManager labelManager;

    public AjaxResponse autocompleteLabels(String entityIdString, String labelPrefix) {
        if (labelPrefix == null) {
            return AjaxResponse.failure(this.getText("label.must.not.be.null"));
        }
        AbstractPage entity = null;
        try {
            long entityId = Long.parseLong(entityIdString);
            entity = this.pageManager.getAbstractPage(entityId);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String remoteUser = AuthenticatedUserThreadLocal.getUsername();
        List suggestedLabels = entity != null ? LabelUtil.getRecentAndPopularLabelsForEntity(entity, this.labelManager, 50, remoteUser) : LabelUtil.getRecentAndPopularLabels(null, this.labelManager, 50, remoteUser);
        ArrayList<Label> autocompleteLabels = new ArrayList<Label>();
        for (Label label : suggestedLabels) {
            if (!StringUtils.startsWith((String)label.getName(), (String)labelPrefix)) continue;
            autocompleteLabels.add(label);
        }
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("filteredList", autocompleteLabels);
        return AjaxResponse.success(VelocityUtils.getRenderedTemplate("labels/autocompletelabelslist.vm", contextMap));
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }
}

