/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels.actions;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelPermissionSupport;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.actions.AbstractLabelEntityBean;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.ImplementsIsPermitted;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.ajax.AjaxResponse;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.util.List;

public class RemoveLabelFromEntityBean
extends AbstractLabelEntityBean
implements ImplementsIsPermitted {
    private PageManager pageManager;
    private PermissionManager permissionManager;
    private LabelManager labelManager;

    public void removeFavourite(String entityIdString) {
        long entityId = Long.parseLong(entityIdString);
        AbstractPage entity = this.pageManager.getAbstractPage(entityId);
        String username = AuthenticatedUserThreadLocal.getUsername();
        this.labelManager.removeLabel(entity, new Label("favourite", Namespace.PERSONAL, username));
        this.labelManager.removeLabel(entity, new Label("favorite", Namespace.PERSONAL, username));
    }

    public AjaxResponse removeLabel(String entityIdString, String labelIdString) throws Exception {
        Label label;
        AbstractPage entity;
        try {
            entity = this.pageManager.getAbstractPage(Long.parseLong(entityIdString));
        }
        catch (NumberFormatException e) {
            return AjaxResponse.failure(e.getClass() + ": Invalid page ID '" + entityIdString + "'");
        }
        if (entity == null) {
            return AjaxResponse.failure(this.getText("no.page.found.for.id", new Object[]{entityIdString}));
        }
        try {
            label = this.labelManager.getLabel(Long.parseLong(labelIdString));
        }
        catch (NumberFormatException e) {
            return AjaxResponse.failure(e.getClass() + ": Invalid label ID '" + labelIdString + "'");
        }
        if (label == null) {
            return AjaxResponse.failure(this.getText("no.page.found.for.id", new Object[]{labelIdString}));
        }
        if (!LabelPermissionSupport.userCanEditLabel(label, (Labelable)entity, this.permissionManager)) {
            return AjaxResponse.failure(this.getText("not.permitted.to.remove.label", new Object[]{"'" + label.getDisplayTitle() + "'"}));
        }
        this.labelManager.removeLabel(entity, label);
        return AjaxResponse.success(labelIdString);
    }

    public boolean isPersonalLabel(Label label) {
        User user = AuthenticatedUserThreadLocal.getUser();
        return user != null && Namespace.isPersonal(label) && TextUtils.noNull((String)label.getOwner()).equals(user.getName());
    }

    public boolean isPermitted(List parameters) {
        if (parameters.size() != 1) {
            throw new RuntimeException("expected 1 parameter");
        }
        Object entity = parameters.get(0);
        if (!(entity instanceof Labelable)) {
            return false;
        }
        return LabelPermissionSupport.userCanEditLabels((Labelable)entity, this.permissionManager);
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }
}

