/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.labels.actions;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ListQuery;
import com.atlassian.confluence.core.SmartListManager;
import com.atlassian.confluence.labels.CombinedLabel;
import com.atlassian.confluence.labels.DisplayableLabel;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.actions.AbstractLabelDisplayingAction;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.util.ContentEntityObjectTitleComparator;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.LabelUtil;
import com.opensymphony.webwork.ServletActionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.BooleanClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewLabelAction
extends AbstractLabelDisplayingAction {
    public static final int ITEMS_PER_PAGE = 10;
    private static final int MAX_RELATED_LABELS_PER_LABEL = 100;
    private static final Comparator<DisplayableLabel> LABEL_TITLE_COMPARATOR = new Comparator<DisplayableLabel>(){

        @Override
        public int compare(DisplayableLabel label1, DisplayableLabel label2) {
            return label1.getRealTitle().compareTo(label2.getRealTitle());
        }
    };
    private long[] ids;
    private List<DisplayableLabel> labels;
    protected PaginationSupport paginationSupport = new PaginationSupport(10);
    private List related = new LinkedList();
    private List content = new LinkedList();
    public List preloadedPage;
    private SmartListManager smartListManager;
    private DisplayableLabel combinedLabel;

    public void setIds(long[] ids) {
        this.ids = ids;
    }

    public void setStartIndex(int startIndex) {
        this.getPaginationSupport().setStartIndex(startIndex);
    }

    public void setSmartListManager(SmartListManager smartListManager) {
        this.smartListManager = smartListManager;
    }

    public List getLabels() {
        return this.labels;
    }

    public List getContent() {
        return this.content;
    }

    public List getRelated() {
        return this.related;
    }

    public PaginationSupport getPaginationSupport() {
        return this.paginationSupport;
    }

    public void validate() {
        if (ArrayUtils.isEmpty((long[])this.ids)) {
            this.getPaginationSupport().setItems(Collections.EMPTY_LIST);
            this.addActionError(this.getText("error.no.label"));
        }
    }

    public String execute() throws Exception {
        if (this.hasErrors()) {
            return "error";
        }
        this.labels = this.retrieveLabels();
        if (this.labels.size() == 0) {
            this.getPaginationSupport().setItems(Collections.EMPTY_LIST);
            ServletActionContext.getResponse().sendError(404);
            return "error";
        }
        this.content = this.getSearchResults();
        this.getPaginationSupport().setItems(this.content);
        this.related = this.getLabelManager().getRelatedLabels(this.labels, this.getSpaceKey(), 100);
        this.preloadResults();
        return "success";
    }

    private List getSearchResults() {
        ListQuery query = new ListQuery();
        query.addSpace(this.getSpace());
        query.setLabelList(this.labels);
        query.setLabelOccur(BooleanClause.Occur.MUST);
        query.setTypeList(LabelManager.CONTENT_TYPES);
        query.setUser(this.getRemoteUser());
        query.setMaxResults(Integer.MAX_VALUE);
        List results = this.smartListManager.getListQueryResults(query, true);
        Collections.sort(results, ContentEntityObjectTitleComparator.getInstance());
        return results;
    }

    private void preloadResults() {
        this.preloadedPage = this.getPaginationSupport().getPage();
        for (Object aPreloadedPage : this.preloadedPage) {
            ContentEntityObject c = (ContentEntityObject)aPreloadedPage;
            c.getUrlPath();
        }
        this.getPaginationSupport().getPreviousStartIndexes();
    }

    private List<DisplayableLabel> retrieveLabels() {
        ArrayList<DisplayableLabel> labels = new ArrayList<DisplayableLabel>();
        if (!ArrayUtils.isEmpty((long[])this.ids)) {
            for (long id : this.ids) {
                Label label = this.getLabelManager().getLabel(id);
                if (label == null) continue;
                labels.add(label);
            }
        }
        return labels;
    }

    @Override
    public boolean isViewPermissionRequired() {
        return false;
    }

    public List<DisplayableLabel> getOtherLabels(ContentEntityObject content) {
        ArrayList<DisplayableLabel> otherLabels = new ArrayList<DisplayableLabel>();
        for (Label label : content.getLabels()) {
            if (this.labels.contains(label) || !Namespace.GLOBAL.equals(label.getNamespace())) continue;
            otherLabels.add(label);
            if (otherLabels.size() < 8) continue;
            break;
        }
        return otherLabels;
    }

    public List getPreloadedPage() {
        return this.preloadedPage;
    }

    public DisplayableLabel getLabel() {
        if (this.combinedLabel == null && this.labels != null && this.labels.size() > 0) {
            this.combinedLabel = new CombinedLabel(this.labels);
        }
        return this.combinedLabel;
    }

    public DisplayableLabel getAddLabel(Label label) {
        ArrayList<DisplayableLabel> labelList = new ArrayList<DisplayableLabel>(this.labels);
        labelList.add(label);
        Collections.sort(labelList, LABEL_TITLE_COMPARATOR);
        return new CombinedLabel(labelList);
    }

    public DisplayableLabel getRemoveLabel(Label label) {
        ArrayList<DisplayableLabel> labelList = new ArrayList<DisplayableLabel>(this.labels);
        labelList.remove(label);
        Collections.sort(labelList, LABEL_TITLE_COMPARATOR);
        return new CombinedLabel(labelList);
    }

    public String getPaginationUrl() {
        String idParams = "ids=" + LabelUtil.joinIds(this.labels, "&ids=");
        String spaceParam = "";
        String spaceKey = this.getSpaceKey();
        if (StringUtils.isNotBlank((String)spaceKey)) {
            spaceParam = "&key=" + GeneralUtil.urlEncode(spaceKey);
        }
        return "labels/viewlabel.action?" + idParams + spaceParam + "&";
    }

    private String getSpaceKey() {
        return this.getSpace() != null ? this.getSpace().getKey() : "";
    }

    @Override
    public WebInterfaceContext getWebInterfaceContext() {
        DefaultWebInterfaceContext context = new DefaultWebInterfaceContext(super.getWebInterfaceContext());
        context.setLabel(this.getLabel());
        return context;
    }
}

