/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.languages;

import com.atlassian.confluence.event.events.plugin.PluginEvent;
import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.languages.LanguageComparator;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.plugin.descriptor.LanguageModuleDescriptor;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.atlassian.event.EventManager;
import com.atlassian.plugin.PluginAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Category;

public class DefaultLanguageManager
implements LanguageManager {
    private static final Category log = Category.getInstance(DefaultLanguageManager.class);
    private PluginAccessor pluginAccessor;
    private EventManager eventManager;
    private List languages;

    public static Language getDefaultEnglishLanguage() {
        Language language = new Language(LocaleManager.DEFAULT_LOCALE);
        language.setFlagUrl("/images/en_GB.gif");
        return language;
    }

    public List getAvailableLanguageDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(LanguageModuleDescriptor.class);
    }

    public Language getLanguage(String languageKey) {
        List languagesList = this.getLanguages();
        for (int i = 0; i < languagesList.size(); ++i) {
            Language language = (Language)languagesList.get(i);
            if (!language.getName().equals(languageKey)) continue;
            return language;
        }
        log.warn((Object)("Unable to find configured language module: " + languageKey));
        return null;
    }

    public List getLanguages() {
        if (this.languages == null) {
            List installedLanguagePacks = this.getAvailableLanguageDescriptors();
            ArrayList<Language> languageList = new ArrayList<Language>();
            languageList.add(DefaultLanguageManager.getDefaultEnglishLanguage());
            for (int i = 0; i < installedLanguagePacks.size(); ++i) {
                LanguageModuleDescriptor descriptor = (LanguageModuleDescriptor)((Object)installedLanguagePacks.get(i));
                Language language = new Language(descriptor);
                languageList.add(language);
            }
            Collections.sort(languageList, new LanguageComparator());
            this.languages = languageList;
        }
        return this.languages;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void init() {
        this.eventManager.registerListener(DefaultLanguageManager.class.getName(), new EventListener(){

            public void handleEvent(Event event) {
                DefaultLanguageManager.this.setLanguages(null);
            }

            public Class[] getHandledEventClasses() {
                return new Class[]{PluginEvent.class};
            }
        });
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    private void setLanguages(List languages) {
        this.languages = languages;
    }
}

