/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.languages;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.util.Locale;
import java.util.StringTokenizer;

public class DefaultLocaleManager
implements LocaleManager {
    private SettingsManager settingsManager;
    private UserAccessor userAccessor;

    public Locale getLocale(User user) {
        UserPreferences prefs;
        String userLocaleString;
        if (BootstrapUtils.getBootstrapManager().isSetupComplete() && user != null && TextUtils.stringSet((String)(userLocaleString = (prefs = new UserPreferences(this.userAccessor.getPropertySet(user))).getString("confluence.user.locale")))) {
            return this.toLocale(userLocaleString);
        }
        if (this.settingsManager != null && this.settingsManager.getGlobalSettings().getGlobalDefaultLocale() != null) {
            return this.toLocale(this.settingsManager.getGlobalSettings().getGlobalDefaultLocale());
        }
        return DEFAULT_LOCALE;
    }

    public Locale toLocale(String userLocaleString) {
        if (!TextUtils.stringSet((String)userLocaleString)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(userLocaleString, "_");
        String language = "";
        String country = "";
        String variant = "";
        language = st.nextToken();
        if (st.hasMoreTokens()) {
            country = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            variant = st.nextToken();
        }
        while (st.hasMoreTokens()) {
            variant = variant + "_" + st.nextToken();
        }
        return new Locale(language, country, variant);
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

