/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PageContentEntityObject;
import com.atlassian.confluence.links.AbstractAttachmentLink;
import com.atlassian.confluence.links.DraftAttachmentLink;
import com.atlassian.confluence.links.LinkParserHelper;
import com.atlassian.confluence.links.linktypes.AttachmentLink;
import com.atlassian.confluence.links.linktypes.BlogPostLink;
import com.atlassian.confluence.links.linktypes.ContentLink;
import com.atlassian.confluence.links.linktypes.IncludePageMacroLink;
import com.atlassian.confluence.links.linktypes.PageCreateLink;
import com.atlassian.confluence.links.linktypes.PageLink;
import com.atlassian.confluence.links.linktypes.ShortcutLink;
import com.atlassian.confluence.links.linktypes.SpaceLink;
import com.atlassian.confluence.links.linktypes.UserProfileLink;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.ShortcutLinksManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.renderer.links.UnpermittedLink;
import com.atlassian.renderer.links.UnresolvedLink;
import com.atlassian.renderer.links.UrlLink;
import com.atlassian.renderer.v2.macro.MacroManager;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import com.opensymphony.util.UrlUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;

public class ConfluenceLinkResolver
implements LinkResolver {
    private static final Category log = Category.getInstance(ConfluenceLinkResolver.class);
    private PageManager pageManager;
    private SpaceManager spaceManager;
    private UserAccessor userAccessor;
    private PermissionManager permissionManager;
    private AttachmentManager attachmentManager;
    private SettingsManager settingsManager;
    private ContentEntityManager contentEntityManager;
    private ShortcutLinksManager shortcutLinksManager;
    private MacroManager macroManager;

    public List extractLinkTextList(String pageContent) {
        LinkParserHelper helper = new LinkParserHelper(pageContent, this.macroManager, this.settingsManager);
        return helper.extractLinks();
    }

    public List extractLinks(RenderContext context, String pageContent) {
        if (!(context instanceof PageContext)) {
            throw new IllegalArgumentException("expecting a PageContext object, got " + context.getClass().getName());
        }
        ArrayList<Link> result = new ArrayList<Link>();
        for (String linkText : this.extractLinkTextList(pageContent)) {
            result.add(this.createLink(context, this.removeLinkBrackets(linkText)));
        }
        return result;
    }

    public String removeLinkBrackets(String linkText) {
        if (TextUtils.stringSet((String)linkText) && linkText.startsWith("[") && linkText.endsWith("]")) {
            return linkText.substring(1, linkText.length() - 1);
        }
        return linkText;
    }

    public Link createLink(RenderContext context, String linkText) {
        if (!(context instanceof PageContext)) {
            throw new IllegalArgumentException("expecting a PageContext object, got " + context.getClass().getName());
        }
        IncludePageMacroLink includePageMacroLink = new IncludePageMacroLink(linkText);
        if (includePageMacroLink.isValid()) {
            return includePageMacroLink;
        }
        PageContext pageContext = (PageContext)context;
        try {
            GenericLinkParser parser = new GenericLinkParser(linkText);
            if (TextUtils.stringSet((String)parser.getNotLinkBody())) {
                if (this.isUrlLink(parser.getNotLinkBody()) || parser.getNotLinkBody().startsWith("//") || parser.getNotLinkBody().startsWith("\\\\")) {
                    return new UrlLink(parser);
                }
                parser.parseAsContentLink();
                if (parser.getContentId() > 0L) {
                    return this.makeContentLink(parser);
                }
                if (TextUtils.stringSet((String)parser.getShortcutName()) && this.shortcutLinksManager.hasShortcutLink(parser.getShortcutName())) {
                    return this.makeShortcutLink(parser);
                }
                if (parser.getDestinationTitle().startsWith("~")) {
                    return this.makeUserProfileLink(parser);
                }
                if (TextUtils.stringSet((String)parser.getShortcutName())) {
                    return new UnresolvedLink(parser.getOriginalLinkText(), TextUtils.stringSet((String)parser.getLinkBody()) ? parser.getLinkBody() : parser.getOriginalLinkText());
                }
                if (!TextUtils.stringSet((String)parser.getDestinationTitle()) && TextUtils.stringSet((String)parser.getSpaceKey())) {
                    return this.makeSpaceLink(parser);
                }
                if (this.isLinkToBlogPost(parser, pageContext)) {
                    return this.makeBlogPostLink(parser, pageContext);
                }
                if (TextUtils.stringSet((String)parser.getAttachmentName())) {
                    return this.makeAttachmentLink(parser, pageContext);
                }
                if (this.isLinkToPage(parser)) {
                    return this.makePageLink(parser, pageContext);
                }
            }
        }
        catch (ParseException e) {
            log.info((Object)("Parse error while parsing link " + linkText), (Throwable)e);
        }
        return new UnresolvedLink(linkText);
    }

    private boolean isLinkToPage(GenericLinkParser parser) {
        return TextUtils.stringSet((String)parser.getDestinationTitle()) || TextUtils.stringSet((String)parser.getAnchor());
    }

    private boolean isLinkToBlogPost(GenericLinkParser parser, PageContext pageContext) {
        return parser.getDestinationTitle().indexOf("/") >= 0 || this.isAnchorToSameBlogPost(pageContext, parser);
    }

    private Link makeContentLink(GenericLinkParser parser) {
        ContentLink link = new ContentLink(parser, this.contentEntityManager);
        if (!link.hasDestination()) {
            return new UnresolvedLink(parser.getOriginalLinkText(), (Link)link);
        }
        if (!this.isUserPermittedToView(link.getDestinationContent())) {
            return new UnpermittedLink((Link)link);
        }
        return link;
    }

    private Link makeShortcutLink(GenericLinkParser parser) {
        ShortcutLink link = new ShortcutLink(parser, this.shortcutLinksManager);
        if (link.hasDestination()) {
            return link;
        }
        return new UnresolvedLink(parser.getOriginalLinkText(), (Link)link);
    }

    private Link makeSpaceLink(GenericLinkParser parser) {
        SpaceLink link = new SpaceLink(parser, this.spaceManager);
        if (!link.hasDestination()) {
            return new UnresolvedLink(parser.getOriginalLinkText(), (Link)link);
        }
        if (!this.isUserPermittedToViewSpace(link.getSpaceKey())) {
            return new UnpermittedLink((Link)link);
        }
        return link;
    }

    private Link makeUserProfileLink(GenericLinkParser parser) throws ParseException {
        UserProfileLink link = new UserProfileLink(parser, this.userAccessor);
        if (link.hasDestination()) {
            return link;
        }
        return new UnresolvedLink(parser.getOriginalLinkText(), (Link)link);
    }

    private Link makeBlogPostLink(GenericLinkParser parser, PageContext pageContext) throws ParseException {
        BlogPostLink blogPostLink = new BlogPostLink(parser, pageContext, this.pageManager);
        if (!blogPostLink.hasDestination()) {
            return new UnresolvedLink(parser.getOriginalLinkText(), (Link)blogPostLink);
        }
        if (!this.isUserPermittedToViewSpace(blogPostLink.getSpaceKey())) {
            return new UnpermittedLink((Link)blogPostLink);
        }
        return blogPostLink;
    }

    private Link makePageLink(GenericLinkParser parser, PageContext pageContext) throws ParseException {
        PageLink pageLink = new PageLink(parser, pageContext, this.pageManager);
        if (!pageLink.hasDestination()) {
            return this.makeCreateLink(pageLink, parser, pageContext);
        }
        if (this.isUserPermittedToViewSpace(pageLink.getSpaceKey())) {
            return pageLink;
        }
        return new UnpermittedLink((Link)pageLink);
    }

    private Link makeAttachmentLink(GenericLinkParser parser, PageContext pageContext) throws ParseException {
        AbstractAttachmentLink attachmentLink = null;
        ContentEntityObject entity = pageContext.getEntity();
        if (entity instanceof PageContentEntityObject) {
            entity = ((PageContentEntityObject)entity).getPage();
        }
        if (this.isLinkToPage(parser)) {
            PageLink pageLink = new PageLink(parser, pageContext, this.pageManager);
            attachmentLink = new AttachmentLink(parser, pageLink, this.attachmentManager);
        } else if (this.isLinkToBlogPost(parser, pageContext)) {
            BlogPostLink blogPostLink = new BlogPostLink(parser, pageContext, this.pageManager);
            attachmentLink = new AttachmentLink(parser, blogPostLink, this.attachmentManager);
        } else if (entity instanceof Draft) {
            attachmentLink = new DraftAttachmentLink(parser, (Draft)entity, this.attachmentManager);
        } else if (entity instanceof Page) {
            PageLink pageLink = new PageLink(parser, pageContext, this.pageManager);
            attachmentLink = new AttachmentLink(parser, pageLink, this.attachmentManager);
        } else if (entity instanceof BlogPost) {
            BlogPostLink blogPostLink = new BlogPostLink(parser, pageContext, this.pageManager);
            attachmentLink = new AttachmentLink(parser, blogPostLink, this.attachmentManager);
        } else {
            return new UnresolvedLink(parser.getOriginalLinkText());
        }
        if (attachmentLink.getAttachment() == null) {
            return new UnresolvedLink(parser.getOriginalLinkText());
        }
        if (!this.isUserPermittedToView(attachmentLink.getAttachment())) {
            return new UnpermittedLink((Link)attachmentLink);
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, attachmentLink.getAttachment())) {
            return new UnpermittedLink((Link)attachmentLink);
        }
        return attachmentLink;
    }

    private Link makeCreateLink(PageLink pageLink, GenericLinkParser parser, PageContext pageContext) throws ParseException {
        if (this.spaceManager.getSpace(pageLink.getSpaceKey()) == null) {
            return new UnresolvedLink(pageLink.getOriginalLinkText(), (Link)pageLink);
        }
        if (this.isUserPermittedToCreatePage(pageLink.getSpaceKey())) {
            return new PageCreateLink(parser, pageContext);
        }
        return new UnpermittedLink((Link)new PageCreateLink(parser, pageContext));
    }

    private boolean isAnchorToSameBlogPost(PageContext pageContext, GenericLinkParser parser) {
        return pageContext.getPostingDay() != null && !TextUtils.stringSet((String)parser.getDestinationTitle()) && parser.getOriginalLinkText().indexOf("#") != -1;
    }

    private boolean isUrlLink(String textWithoutTitle) {
        if (textWithoutTitle.startsWith("mailto:") || textWithoutTitle.startsWith("file:")) {
            return true;
        }
        String encodedText = textWithoutTitle.replaceAll("'", "");
        boolean isUrl = UrlUtils.verifyHierachicalURI((String)encodedText);
        return isUrl;
    }

    private boolean isUserPermittedToCreatePage(String spaceKey) {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (GeneralUtil.isSuperUser(user)) {
            return true;
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        return this.permissionManager.hasCreatePermission(user, space, Page.class);
    }

    private boolean isUserPermittedToViewSpace(String spaceKey) {
        return this.isUserPermittedToView(this.spaceManager.getSpace(spaceKey));
    }

    private boolean isUserPermittedToView(Object object) {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (GeneralUtil.isSuperUser(user)) {
            return true;
        }
        return this.permissionManager.hasPermission(user, Permission.VIEW, object);
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setShortcutLinksManager(ShortcutLinksManager shortcutLinksManager) {
        this.shortcutLinksManager = shortcutLinksManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setMacroManager(MacroManager macroManager) {
        this.macroManager = macroManager;
    }
}

