/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.links.OutgoingLinkHelper;
import com.atlassian.confluence.links.persistence.dao.LinkDao;
import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.AttachmentLinkRenamingBean;
import com.atlassian.confluence.util.BlogPostLinkRenamingBean;
import com.atlassian.confluence.util.CamelCaseLinkRenamingBean;
import com.atlassian.confluence.util.IncludePageMacroLinkRenamingBean;
import com.atlassian.confluence.util.PageLinkRenamingBean;
import com.atlassian.confluence.util.SelfPageLinkRenamingBean;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.renderer.v2.macro.MacroManager;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

public class DefaultLinkManager
implements LinkManager {
    public static final Category log = Category.getInstance(DefaultLinkManager.class);
    private LinkDao linkDao;
    private LinkResolver linkResolver;
    private SettingsManager settingsManager;
    private MacroManager macroManager;

    public void setLinkDao(LinkDao linkDao) {
        this.linkDao = linkDao;
    }

    public void setLinkResolver(LinkResolver linkResolver) {
        this.linkResolver = linkResolver;
    }

    private LinkResolver getLinkResolver() {
        if (this.linkResolver == null && ContainerManager.isContainerSetup()) {
            this.linkResolver = (LinkResolver)ContainerManager.getComponent((String)"linkResolver");
        }
        return this.linkResolver;
    }

    public void removeLink(OutgoingLink link) {
        link.getSourceContent().removeOutgoingLink(link);
        this.linkDao.remove(link);
    }

    public void saveLink(OutgoingLink link) {
        link.getSourceContent().addOutgoingLink(link);
        this.linkDao.save(link);
    }

    public List getIncomingLinksToContent(ContentEntityObject content) {
        List links = this.linkDao.getLinksTo(content);
        if (links != null) {
            Collections.sort(links, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int result;
                    block2: {
                        result = 1;
                        try {
                            result = ((OutgoingLink)o1).getSourceContent().compareTo(((OutgoingLink)o2).getSourceContent());
                        }
                        catch (ClassCastException e) {
                            if (!log.isDebugEnabled()) break block2;
                            log.debug((Object)("Error comparing " + o1 + " with " + o2), (Throwable)e);
                        }
                    }
                    return result;
                }
            });
        }
        return links;
    }

    public List extractLinksFromContent(ContentEntityObject content) {
        return this.getLinkResolver().extractLinks((RenderContext)content.toPageContext(), content.getContent());
    }

    public String getSelfContentWithRenamedLinks(ContentEntityObject referringContent, String newSpaceKey) {
        SelfPageLinkRenamingBean selfPageLinkRenamingBean = new SelfPageLinkRenamingBean(referringContent, newSpaceKey);
        selfPageLinkRenamingBean.setMacroManager(this.macroManager);
        referringContent.setContent(selfPageLinkRenamingBean.getRenamedContent());
        return referringContent.getContent();
    }

    public String getContentWithRenamedLinks(ContentEntityObject referringContent, SpaceContentEntityObject pageBeingChanged, String newSpaceKey, String newPageTitle) {
        if (pageBeingChanged.getSpaceKey().equals(TextUtils.noNull((String)newSpaceKey).trim()) && pageBeingChanged.getTitle().equals(TextUtils.noNull((String)newPageTitle).trim())) {
            throw new IllegalArgumentException("The new and old link strings are the same. Nothing to rename!");
        }
        if (StringUtils.isEmpty((String)newSpaceKey)) {
            newSpaceKey = pageBeingChanged.getSpaceKey();
        }
        if (StringUtils.isEmpty((String)newPageTitle)) {
            newPageTitle = pageBeingChanged.getTitle();
        }
        if (pageBeingChanged instanceof Page) {
            PageLinkRenamingBean pageLinkRenamingBean = new PageLinkRenamingBean(referringContent, pageBeingChanged, newSpaceKey, newPageTitle);
            pageLinkRenamingBean.setMacroManager(this.macroManager);
            referringContent.setContent(pageLinkRenamingBean.getRenamedContent());
        }
        if (pageBeingChanged instanceof BlogPost) {
            BlogPostLinkRenamingBean blogPostLinkRenamingBean = new BlogPostLinkRenamingBean(referringContent, pageBeingChanged, newSpaceKey, newPageTitle);
            blogPostLinkRenamingBean.setMacroManager(this.macroManager);
            referringContent.setContent(blogPostLinkRenamingBean.getRenamedContent());
        }
        CamelCaseLinkRenamingBean camelCaseLinkRenamingBean = new CamelCaseLinkRenamingBean(referringContent, pageBeingChanged, newSpaceKey, newPageTitle);
        camelCaseLinkRenamingBean.setSettingsManager(this.settingsManager);
        camelCaseLinkRenamingBean.setMacroManager(this.macroManager);
        referringContent.setContent(camelCaseLinkRenamingBean.getRenamedContent());
        IncludePageMacroLinkRenamingBean includePageMacroLinkRenamingBean = new IncludePageMacroLinkRenamingBean(referringContent, pageBeingChanged, newSpaceKey, newPageTitle);
        includePageMacroLinkRenamingBean.setMacroManager(this.macroManager);
        referringContent.setContent(includePageMacroLinkRenamingBean.getRenamedContent());
        AttachmentLinkRenamingBean attachmentLinkRenamingBean = new AttachmentLinkRenamingBean(referringContent, pageBeingChanged, newSpaceKey, newPageTitle);
        referringContent.setContent(attachmentLinkRenamingBean.getRenamedContent());
        return referringContent.getContent();
    }

    public void renameOutgoingLinksToAttachments(ContentEntityObject referringContent, String existingFileName, String newFileName) {
        if (StringUtils.isEmpty((String)existingFileName) || StringUtils.isEmpty((String)newFileName)) {
            throw new IllegalArgumentException("None of the arguments should be empty string nor null!");
        }
        if (existingFileName.equals(newFileName.trim())) {
            throw new IllegalArgumentException("The new and old link strings are the same. Nothing to rename!");
        }
        AttachmentLinkRenamingBean attachmentLinkRenamingBean = new AttachmentLinkRenamingBean(referringContent, existingFileName, newFileName);
        referringContent.setContent(attachmentLinkRenamingBean.getRenamedContent());
    }

    public void renameOutgoingLinksToMovedAttachments(ContentEntityObject referringContent, String existingFileName, String newFileName, ContentEntityObject srcContent, ContentEntityObject destContent) {
        if (StringUtils.isEmpty((String)existingFileName) || StringUtils.isEmpty((String)newFileName)) {
            throw new IllegalArgumentException("None of the arguments should be empty string nor null!");
        }
        AttachmentLinkRenamingBean attachmentLinkRenamingBean = new AttachmentLinkRenamingBean(referringContent, existingFileName, newFileName, srcContent, destContent);
        referringContent.setContent(attachmentLinkRenamingBean.getRenamedContent());
    }

    public void updateOutgoingLinks(ContentEntityObject content) {
        if (content == null || content instanceof Mail) {
            return;
        }
        int n = content.getOutgoingLinks().size();
        for (int i = 0; i < n; ++i) {
            this.removeLink((OutgoingLink)content.getOutgoingLinks().get(0));
        }
        if (!content.isLatestVersion()) {
            return;
        }
        OutgoingLinkHelper outgoingLinkHelper = new OutgoingLinkHelper(content, this.getLinkResolver());
        for (OutgoingLink outgoingLink : outgoingLinkHelper.getOutgoingLinks()) {
            String url = outgoingLink.getDestinationPageTitle();
            if (TextUtils.stringSet((String)url) && url.length() > 255) {
                outgoingLink.setDestinationPageTitle(url.substring(0, 255));
            }
            this.saveLink(outgoingLink);
        }
    }

    public Collection getReferringContent(ContentEntityObject content) {
        return this.linkDao.getReferringContent(content);
    }

    public void removeCorruptOutgoingLinks() {
        this.linkDao.removeCorruptOutgoingLinks();
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setMacroManager(MacroManager macroManager) {
        this.macroManager = macroManager;
    }
}

