/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PageContentEntityObject;
import com.atlassian.confluence.links.AbstractLink;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.renderer.util.UrlUtil;
import net.sf.hibernate.Hibernate;

public class OutgoingLink
extends AbstractLink
implements Comparable {
    private String destinationSpaceKey;
    private String destinationPageTitle;

    public OutgoingLink() {
    }

    public OutgoingLink(ContentEntityObject sourceContent, String destinationSpaceKey, String destinationPageTitle) {
        this.setSourceContent(sourceContent);
        this.destinationPageTitle = destinationPageTitle;
        this.destinationSpaceKey = destinationSpaceKey;
    }

    public String getDestinationPageTitle() {
        return this.destinationPageTitle;
    }

    public void setDestinationPageTitle(String destinationPageTitle) {
        if (destinationPageTitle != null && destinationPageTitle.length() > 255) {
            destinationPageTitle = destinationPageTitle.substring(0, 255);
        }
        this.destinationPageTitle = destinationPageTitle;
    }

    public String getDestinationSpaceKey() {
        return this.destinationSpaceKey;
    }

    public void setDestinationSpaceKey(String destinationSpaceKey) {
        if (destinationSpaceKey != null && destinationSpaceKey.length() > 255) {
            destinationSpaceKey = destinationSpaceKey.substring(0, 255);
        }
        this.destinationSpaceKey = destinationSpaceKey;
    }

    public boolean isUrlLink() {
        for (String protocol : UrlUtil.URL_PROTOCOLS) {
            int index = protocol.indexOf(58);
            if (index != -1) {
                protocol = protocol.substring(0, index);
            }
            if (!protocol.equalsIgnoreCase(this.getDestinationSpaceKey())) continue;
            return true;
        }
        return false;
    }

    public String getUrlLink() {
        return this.getDestinationSpaceKey() + ":" + this.getDestinationPageTitle();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OutgoingLink that = (OutgoingLink)o;
        if (this.getDestinationPageTitle() != null ? !this.getDestinationPageTitle().equals(that.getDestinationPageTitle()) : that.getDestinationPageTitle() != null) {
            return false;
        }
        return !(this.getDestinationSpaceKey() != null ? !this.getDestinationSpaceKey().equals(that.getDestinationSpaceKey()) : that.getDestinationSpaceKey() != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.getDestinationSpaceKey() != null ? this.getDestinationSpaceKey().hashCode() : 0);
        result = 29 * result + (this.getDestinationPageTitle() != null ? this.getDestinationPageTitle().hashCode() : 0);
        return result;
    }

    public int compareTo(Object o) {
        OutgoingLink other = (OutgoingLink)o;
        int comparison = this.getSourceContent().compareTo(other.getSourceContent());
        if (comparison == 0 && (comparison = this.getDestinationSpaceKey().compareTo(other.getDestinationSpaceKey())) == 0) {
            comparison = this.getDestinationPageTitle().compareTo(other.getDestinationPageTitle());
        }
        return comparison;
    }

    public String toString() {
        return this.getUrlLink();
    }

    public boolean isFrom(AbstractPage page) {
        ContentEntityObject source = this.getSourceContent();
        if (page == null || source == null) {
            return false;
        }
        if (source instanceof AbstractPage) {
            return source.getId() == page.getId();
        }
        if (source instanceof PageContentEntityObject) {
            return ((PageContentEntityObject)source).getPage().getId() == page.getId();
        }
        return false;
    }
}

