/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PageContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.links.LinkResolver;
import com.opensymphony.util.TextUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OutgoingLinkHelper {
    private static final Logger log = Logger.getLogger(OutgoingLinkHelper.class);
    private ContentEntityObject content;
    private LinkResolver linkResolver;

    public OutgoingLinkHelper(ContentEntityObject content, LinkResolver linkResolver) {
        this.content = content;
        this.linkResolver = linkResolver;
    }

    public Collection getOutgoingLinks() {
        ArrayList<OutgoingLink> result = new ArrayList<OutgoingLink>();
        for (String linkText : this.linkResolver.extractLinkTextList(this.content.getContent())) {
            String destinationPageTitle;
            linkText = this.linkResolver.removeLinkBrackets(linkText);
            GenericLinkParser parser = new GenericLinkParser(linkText);
            try {
                parser.parseAsContentLink();
            }
            catch (ParseException e) {
                log.info((Object)("Parse error while parsing link " + linkText), (Throwable)e);
            }
            String destinationSpaceKey = parser.getSpaceKey();
            if (StringUtils.isBlank((String)destinationSpaceKey)) {
                if (this.content instanceof SpaceContentEntityObject) {
                    destinationSpaceKey = ((SpaceContentEntityObject)this.content).getSpaceKey();
                } else {
                    if (!(this.content instanceof PageContentEntityObject)) continue;
                    destinationSpaceKey = ((PageContentEntityObject)this.content).getPage().getSpaceKey();
                }
            }
            if (StringUtils.isBlank((String)(destinationPageTitle = parser.getLinkTitle()))) {
                destinationPageTitle = TextUtils.noNull((String)parser.getDestinationTitle());
            }
            OutgoingLink outgoingLink = new OutgoingLink(this.content, destinationSpaceKey, destinationPageTitle);
            result.add(outgoingLink);
        }
        return result;
    }

    public void setLinkResolver(LinkResolver linkResolver) {
        this.linkResolver = linkResolver;
    }
}

