/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links;

import com.atlassian.confluence.links.AbstractLink;
import com.atlassian.confluence.util.GeneralUtil;
import com.opensymphony.util.TextUtils;
import net.sf.hibernate.Hibernate;

public class ReferralLink
extends AbstractLink
implements Comparable {
    private int viewCount;
    private String url = "";

    public int getViewCount() {
        return this.viewCount;
    }

    public void setViewCount(int viewCount) {
        this.viewCount = viewCount;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (!TextUtils.stringSet((String)url)) {
            url = "";
        }
        this.url = GeneralUtil.constrainLength(url, 255);
    }

    public void incViewCount() {
        ++this.viewCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReferralLink that = (ReferralLink)o;
        if (this.viewCount != that.viewCount) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.viewCount;
        result = 29 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }

    public int compareTo(Object o) {
        ReferralLink other = (ReferralLink)o;
        int result = this.getViewCount() - other.getViewCount();
        if (result == 0) {
            result = this.getUrl().compareTo(other.getUrl());
        }
        return result;
    }
}

