/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links;

import com.atlassian.confluence.links.ReferralManager;
import com.atlassian.confluence.links.ReferralTask;
import com.atlassian.core.task.Task;
import com.atlassian.core.task.TaskQueue;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.log4j.Category;

public class ReferralTaskQueue
implements TaskQueue {
    private static Category log = Category.getInstance(ReferralTaskQueue.class);
    private volatile boolean flushing;
    private Buffer items = BufferUtils.synchronizedBuffer((Buffer)new UnboundedFifoBuffer());
    private Buffer currentlyFlushingItems;
    private ReferralManager referralManager;

    public void addTask(Task task) {
        log.debug((Object)("Queued: " + task));
        this.items.add((Object)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.flushing) {
            return;
        }
        try {
            this.flushing = true;
            this.currentlyFlushingItems = this.items;
            this.items = BufferUtils.synchronizedBuffer((Buffer)new UnboundedFifoBuffer());
            HashMap<String, ReferralTask> consolidatedItems = new HashMap<String, ReferralTask>();
            for (ReferralTask task : this.currentlyFlushingItems) {
                String lcReferrerUrl = task.getReferrerUrl().toLowerCase();
                if (consolidatedItems.containsKey(lcReferrerUrl)) {
                    ((ReferralTask)consolidatedItems.get(lcReferrerUrl)).incrementHitCount();
                    continue;
                }
                consolidatedItems.put(lcReferrerUrl, task);
            }
            for (ReferralTask task : consolidatedItems.values()) {
                task.setReferralManager(this.referralManager);
                try {
                    task.execute();
                }
                catch (Exception e) {
                    log.error((Object)("Unable to add referrer " + task.getReferrerUrl() + " - " + e.getMessage()), (Throwable)e);
                }
            }
        }
        finally {
            this.flushing = false;
        }
    }

    public int size() {
        return this.items.size();
    }

    public boolean isFlushing() {
        return false;
    }

    public Timestamp getFlushStarted() {
        return null;
    }

    public void setReferralManager(ReferralManager referralManager) {
        this.referralManager = referralManager;
    }

    public void clear() {
        this.items.clear();
    }

    public Collection getTasks() {
        return this.items;
    }
}

