/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links.linktypes;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.links.linktypes.AbstractContentEntityLink;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.RenderedContentStore;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.util.RendererProperties;
import com.atlassian.renderer.util.RendererUtil;
import com.atlassian.renderer.v2.components.BackslashEscapeRendererComponent;
import com.opensymphony.util.TextUtils;
import java.text.ParseException;
import java.util.Arrays;

public abstract class AbstractPageLink
extends AbstractContentEntityLink {
    protected String spaceKey;
    protected AbstractPage destinationPage;
    protected String anchor;
    private boolean escapeLinkBody;

    public AbstractPageLink(GenericLinkParser parser, PageContext context) throws ParseException {
        super(parser);
        this.entityName = TextUtils.stringSet((String)parser.getDestinationTitle()) ? parser.getDestinationTitle() : context.getPageTitle();
        this.spaceKey = TextUtils.stringSet((String)parser.getSpaceKey()) ? parser.getSpaceKey() : context.getSpaceKey();
        this.anchor = parser.getAnchor();
        if (this.noContextForPage(context)) {
            throw new ParseException("Not enough information to know where to link", 0);
        }
        if (parser.getLinkBody() == null) {
            this.escapeLinkBody = true;
        }
    }

    protected void setUrlAndTitle(PageContext pageContext) {
        if (TextUtils.stringSet((String)this.anchor)) {
            this.setUrlAndTitleWithAnchor(pageContext, this.anchor);
        } else if (this.destinationPage != null) {
            this.url = this.destinationPage.getUrlPath();
            this.setTitle(this.destinationPage.getTitle());
        }
    }

    private void setUrlAndTitleWithAnchor(PageContext pageContext, String anchor) {
        if (this.isOnSamePage(pageContext)) {
            this.url = "#" + this.getAnchor(pageContext);
            this.relativeUrl = false;
        } else {
            this.url = this.destinationPage.getUrlPath() + "#" + this.getAnchor(pageContext);
        }
        this.setI18nTitle(RendererProperties.TITLE_WITH_ANCHOR, Arrays.asList(anchor, this.destinationPage.getTitle()));
    }

    protected abstract boolean isOnSamePage(PageContext var1);

    private boolean noContextForPage(PageContext context) {
        return !TextUtils.stringSet((String)this.spaceKey) && !TextUtils.stringSet((String)context.getSpaceKey()) || !TextUtils.stringSet((String)this.entityName) && !TextUtils.stringSet((String)context.getPageTitle());
    }

    public String getAnchor(PageContext pageContext) {
        if (!TextUtils.stringSet((String)this.anchor)) {
            return null;
        }
        if (this.destinationPage.equals(pageContext.getEntity())) {
            return AbstractPageLink.generateAnchor(new PageContext(pageContext.getOriginalContext().getEntity()), this.anchor);
        }
        return AbstractPageLink.generateAnchor(new PageContext(this.destinationPage), this.anchor);
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getPageTitle() {
        return this.entityName;
    }

    public ContentEntityObject getDestinationContent() {
        return this.destinationPage;
    }

    public OutgoingLink toOutgoingLink(ContentEntityObject sourceContent) {
        OutgoingLink outgoingLink = new OutgoingLink();
        outgoingLink.setDestinationPageTitle(this.getPageTitle());
        outgoingLink.setDestinationSpaceKey(this.getSpaceKey());
        outgoingLink.setSourceContent(sourceContent);
        return outgoingLink;
    }

    public String getLinkBody() {
        if (this.escapeLinkBody) {
            return BackslashEscapeRendererComponent.escapeWiki((String)super.getLinkBody());
        }
        return super.getLinkBody();
    }

    public static String generateAnchor(PageContext context, String anchorTitle) {
        context = context.getOriginalContext();
        String result = "";
        if (context.getPageTitle() != null) {
            result = context.getPageTitle() + "-";
        } else if (context.getSpaceKey() != null) {
            result = context.getSpaceKey() + "-";
        }
        result = result + RendererUtil.summarise((String)TextUtils.noNull((String)RenderedContentStore.stripTokens((String)anchorTitle)).trim());
        result = result.replaceAll(" ", "");
        return GeneralUtil.urlEncode(result);
    }
}

