/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links.persistence.dao.hibernate;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PageContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.ConfluenceHibernateObjectDao;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.links.persistence.dao.LinkDao;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.util.GeneralUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernateLinkDao
extends ConfluenceHibernateObjectDao
implements LinkDao {
    public Class getPersistentClass() {
        return OutgoingLink.class;
    }

    public List getLinksTo(ContentEntityObject theContent) {
        if (theContent == null) {
            return new ArrayList();
        }
        final ContentEntityObject content = theContent = (ContentEntityObject)theContent.getLatestVersion();
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("confluence.links_findOutgoingLinkBySpaceKeyAndPageTitle");
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateLinkDao.this.getSessionFactory());
                String spaceKey = null;
                String pageTitle = HibernateLinkDao.this.extractTitle(content);
                if (content instanceof SpaceContentEntityObject) {
                    spaceKey = ((SpaceContentEntityObject)content).getSpace().getKey();
                } else if (content instanceof PageContentEntityObject) {
                    spaceKey = ((PageContentEntityObject)content).getPage().getSpace().getKey();
                }
                return queryObject.setString("spaceKey", GeneralUtil.specialToLowerCase(spaceKey)).setString("pageTitle", GeneralUtil.specialToLowerCase(pageTitle)).list();
            }
        });
    }

    public List getReferringContent(ContentEntityObject theContent) {
        if (theContent == null) {
            return Collections.EMPTY_LIST;
        }
        final ContentEntityObject content = theContent = (ContentEntityObject)theContent.getLatestVersion();
        List result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createSQLQuery("select {content.*} from CONTENT {content}, LINKS links where {content}.CONTENTID = links.CONTENTID and links.DESTSPACEKEY = ? and lower(links.DESTPAGETITLE) = ?", "content", ContentEntityObject.class);
                SessionFactoryUtils.applyTransactionTimeout((Query)query, (SessionFactory)HibernateLinkDao.this.getSessionFactory());
                query.setString(0, HibernateLinkDao.this.extractSpaceKey(content));
                query.setString(1, GeneralUtil.specialToLowerCase(HibernateLinkDao.this.extractTitle(content)));
                return query.list();
            }
        });
        HashSet unique = new HashSet(result);
        return new ArrayList(unique);
    }

    private String extractSpaceKey(ContentEntityObject obj) {
        if (obj instanceof SpaceContentEntityObject) {
            return ((SpaceContentEntityObject)obj).getSpace().getKey();
        }
        if (obj instanceof PageContentEntityObject) {
            return ((PageContentEntityObject)obj).getPage().getSpace().getKey();
        }
        return "";
    }

    private String extractTitle(ContentEntityObject obj) {
        String pageTitle = obj.getTitle();
        if (obj instanceof BlogPost) {
            pageTitle = ((BlogPost)obj).getLinkPart();
        }
        return pageTitle;
    }

    public List findByDestinationSpaceKey(String spaceKey) {
        if (spaceKey == null) {
            return this.findNamedQuery("confluence.links_findOutgoingLinksWithValidSpaceKey");
        }
        return this.findNamedQueryStringParam("confluence.links_findOutgoingLinksWithSpaceKey", "spaceKey", GeneralUtil.specialToLowerCase(spaceKey));
    }

    public void removeCorruptOutgoingLinks() {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                List corruptLinks = session.createSQLQuery("select {outgoingLink.*} from LINKS {outgoingLink}, CONTENT content where {outgoingLink}.CONTENTID = content.CONTENTID and content.SPACEID IS NULL", "outgoingLink", OutgoingLink.class).list();
                for (OutgoingLink link : corruptLinks) {
                    link.getSourceContent().removeOutgoingLink(link);
                    session.delete((Object)link);
                }
                return null;
            }
        });
    }
}

