/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.links.persistence.dao.hibernate;

import com.atlassian.confluence.core.persistence.hibernate.ConfluenceHibernateObjectDao;
import com.atlassian.confluence.links.ReferralLink;
import com.atlassian.confluence.links.persistence.dao.ReferralDao;
import com.atlassian.confluence.util.GeneralUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import org.springframework.orm.hibernate.HibernateCallback;

public class HibernateReferralDao
extends ConfluenceHibernateObjectDao
implements ReferralDao {
    public Class getPersistentClass() {
        return ReferralLink.class;
    }

    public List findByPrefix(String prefix) {
        return this.findNamedQueryStringParam("confluence.referralLink_findByPattern", "pattern", GeneralUtil.specialToLowerCase(prefix + "%"), false);
    }

    public List findHotReferrers(final long contentId, final int maxResults, final List bannedReferrers) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query queryObject = session.getNamedQuery("confluence_referralLink_findHotReferrers");
                queryObject.setLong("contentId", contentId);
                queryObject.setCacheable(true);
                ArrayList<ReferralLink> result = new ArrayList<ReferralLink>();
                for (ReferralLink referralLink : queryObject.list()) {
                    if (bannedReferrers.contains(referralLink.getUrl())) continue;
                    result.add(referralLink);
                    if (maxResults <= 0 || result.size() != maxResults) continue;
                    break;
                }
                return result;
            }
        });
    }

    public ReferralLink findReferralLink(long contentId, String linkUrl) {
        return (ReferralLink)this.findSingleObject(this.findNamedQueryStringParams("confluence_referralLink_findReferralLink", "contentId", new Long(contentId), "linkUrl", GeneralUtil.specialToLowerCase(linkUrl), true, 1));
    }
}

