/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.logging;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.util.BootstrapUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;

public class ConfluenceHomeLogAppender
extends WriterAppender {
    private static final Logger log = Logger.getLogger(ConfluenceHomeLogAppender.class);
    private static final String DEFAULT_LOG_NAME = "atlassian-confluence.log";
    private ConsoleAppender consoleAppender = new ConsoleAppender();
    private RollingFileAppender confluenceHomeAppender = new RollingFileAppender();
    private WriterAppender currentAppender = this.consoleAppender;
    private List logBuffer = Collections.synchronizedList(new ArrayList());
    private String logFileName;

    public void setMaxFileSize(String value) {
        this.confluenceHomeAppender.setMaxFileSize(value);
    }

    public long getMaximumFileSize() {
        return this.confluenceHomeAppender.getMaximumFileSize();
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.confluenceHomeAppender.setMaxBackupIndex(maxBackups);
    }

    public int getMaxBackupIndex() {
        return this.confluenceHomeAppender.getMaxBackupIndex();
    }

    public void activateOptions() {
        assert (this.consoleAppender != null);
        this.consoleAppender.activateOptions();
    }

    public Layout getLayout() {
        assert (this.confluenceHomeAppender.getLayout() == this.consoleAppender.getLayout()) : "The delegate Appenders have different layouts.";
        return this.consoleAppender.getLayout();
    }

    public void setLayout(Layout layout) {
        this.consoleAppender.setLayout(layout);
        this.confluenceHomeAppender.setLayout(layout);
    }

    public void setLogFileName(String file) {
        this.logFileName = file;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void append(LoggingEvent event) {
        if (this.currentAppender == this.consoleAppender) {
            this.logBuffer.add(event);
        }
        this.currentAppender.append(event);
    }

    public void close() {
        this.consoleAppender.close();
        this.confluenceHomeAppender.close();
    }

    void switchAppender() {
        AtlassianBootstrapManager atlassianBootstrapManager = BootstrapUtils.getBootstrapManager();
        String logsLocation = atlassianBootstrapManager.getApplicationHome() + File.separator + "logs";
        File logDirectory = new File(logsLocation);
        if (!logDirectory.exists() && !logDirectory.mkdir()) {
            log.error((Object)("Could not create logs directory " + logsLocation + ". Logging remains directed to the ConsoleAppender."));
            return;
        }
        if (this.logFileName == null) {
            this.logFileName = DEFAULT_LOG_NAME;
        }
        String logfile = logsLocation + File.separator + this.logFileName;
        this.confluenceHomeAppender.setFile(logfile);
        this.confluenceHomeAppender.activateOptions();
        this.currentAppender = this.confluenceHomeAppender;
        Iterator it = this.logBuffer.iterator();
        while (it.hasNext()) {
            this.currentAppender.append((LoggingEvent)it.next());
        }
        this.logBuffer.clear();
    }
}

