/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.logging;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.logging.ConfluenceHomeLogAppender;
import com.atlassian.confluence.setup.BootstrapContextInitialisedEvent;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class ConfluenceLoggingConfigurationListener
implements ApplicationListener {
    private static final String DEFAULT_APPENDER_NAME = "confluencelog";
    private String logFileName;
    private String appenderName;

    public void setLogFileName(String file) {
        this.logFileName = file;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setAppenderName(String name) {
        this.appenderName = name;
    }

    public String getAppenderName() {
        return this.appenderName;
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof BootstrapContextInitialisedEvent) {
            Appender appender;
            assert (BootstrapUtils.getBootstrapManager().isBootstrapped()) : "BootstrapContextInitialisedEvent raised before Bootstrap is complete";
            String aname = this.getAppenderName();
            if (aname == null) {
                aname = DEFAULT_APPENDER_NAME;
            }
            if ((appender = LogManager.getRootLogger().getAppender(aname)) instanceof ConfluenceHomeLogAppender) {
                ConfluenceHomeLogAppender homeAppender = (ConfluenceHomeLogAppender)appender;
                homeAppender.setLogFileName(this.getLogFileName());
                homeAppender.switchAppender();
            }
        }
    }
}

