/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.macro.params;

import com.atlassian.confluence.macro.MacroExecutionContext;
import com.atlassian.confluence.macro.params.BaseParameter;
import com.atlassian.confluence.macro.params.ParameterException;
import com.atlassian.confluence.macro.params.SortType;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import com.atlassian.confluence.search.v2.sort.RelevanceSort;

public class SearchSortParameter
extends BaseParameter {
    private static final String[] DEFAULT_PARAM_NAMES = new String[]{"sort"};

    public SearchSortParameter() {
        this(null);
    }

    public SearchSortParameter(String defaultValue) {
        super(DEFAULT_PARAM_NAMES, defaultValue);
    }

    protected SearchSort findObject(String paramValue, MacroExecutionContext ctx) throws ParameterException {
        if (paramValue != null) {
            SortType sort = SortType.get(paramValue);
            if (sort == null) {
                throw new ParameterException("sort parameter value cannot be null");
            }
            switch (sort) {
                case TITLE: {
                    return new RelevanceSort();
                }
                case NATURAL: {
                    return new RelevanceSort();
                }
                case CREATION: {
                    return new CreatedSort(SearchSort.Order.ASCENDING);
                }
                case MODIFIED: {
                    return new ModifiedSort(SearchSort.Order.ASCENDING);
                }
            }
            throw new ParameterException("'" + paramValue + "' is not a recogized sort type");
        }
        return null;
    }
}

