/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.macro.query;

import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BooleanQueryFactory {
    private final Set<SearchQuery> must;
    private final Set<SearchQuery> should;
    private final Set<SearchQuery> mustNot;

    public BooleanQueryFactory() {
        this.must = new HashSet<SearchQuery>();
        this.should = new HashSet<SearchQuery>();
        this.mustNot = new HashSet<SearchQuery>();
    }

    public BooleanQueryFactory(Set<SearchQuery> must, Set<SearchQuery> should, Set<SearchQuery> mustNot) {
        this.must = must;
        this.should = should;
        this.mustNot = mustNot;
    }

    public BooleanQuery toBooleanQuery() {
        return new BooleanQuery(this.must, this.should, this.mustNot);
    }

    public void addMust(SearchQuery query) {
        this.must.add(query);
    }

    public void addMust(Collection<? extends SearchQuery> queries) {
        this.must.addAll(queries);
    }

    public void addShould(SearchQuery query) {
        this.should.add(query);
    }

    public void addShould(Collection<? extends SearchQuery> queries) {
        this.should.addAll(queries);
    }

    public void addMustNot(SearchQuery query) {
        this.mustNot.add(query);
    }

    public void addMustNot(Collection<? extends SearchQuery> queries) {
        this.mustNot.addAll(queries);
    }

    Set<SearchQuery> getMust() {
        return Collections.unmodifiableSet(this.must);
    }

    Set<SearchQuery> getShould() {
        return Collections.unmodifiableSet(this.should);
    }

    Set<SearchQuery> getMustNot() {
        return Collections.unmodifiableSet(this.mustNot);
    }

    public void merge(BooleanQueryFactory result) {
        this.addMust(result.getMust());
        this.addShould(result.getShould());
        this.addMustNot(result.getMustNot());
    }
}

