/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PageContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.mail.reports.ChangeDigestReport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;

public class ChangeDigestNotificationBean {
    private static final Category log = Category.getInstance(ChangeDigestNotificationBean.class);
    private ContentEntityManager contentEntityManager;
    private UserAccessor userAccessor;
    private SettingsManager settingsManager;
    private PermissionManager permissionManager;
    private NotificationManager notificationManager;

    public ChangeDigestReport getWatchedChangeReportForUser(User user, List pages) {
        ChangeDigestReport report = new ChangeDigestReport(user, this.userAccessor);
        for (AbstractPage page : pages) {
            if (!this.notificationManager.isUserWatchingPageOrSpace(user, page.getSpace(), page)) continue;
            report.addPage((Page)page);
        }
        return report;
    }

    public ChangeDigestReport getAllChangeReportForUser(User user, List changes) {
        ChangeDigestReport report = new ChangeDigestReport(user, this.userAccessor);
        boolean sharedMode = this.settingsManager.getGlobalSettings().isSharedMode();
        for (ContentEntityObject content : changes) {
            if (!this.userHasAccessTo(user, content)) continue;
            if (content.getType().equals("page")) {
                report.addPage((Page)content);
                continue;
            }
            if (content.getType().equals("blogpost")) {
                report.addBlogPost((BlogPost)content);
                continue;
            }
            if (content.getType().equals("comment")) {
                report.addComment((Comment)content);
                continue;
            }
            if (content.getType().equals("userinfo") && !sharedMode) {
                report.addPersonalInformation((PersonalInformation)content);
                continue;
            }
            log.debug((Object)("Found content type that is not supported in a daily change digest: " + content.getType()));
        }
        return report;
    }

    public boolean isUserNotifiable(User user) {
        UserPreferences prefs = new UserPreferences(this.userAccessor.getPropertySet(user));
        return prefs.getBoolean("confluence.prefs.email.notify");
    }

    private List getContentCreatedOrUpdatedSinceDate(Date fromWhen) {
        List fullContentList = this.contentEntityManager.getEntitiesModifiedSince(fromWhen);
        LinkedList contentList = new LinkedList(fullContentList);
        Iterator iterator = contentList.iterator();
        while (iterator.hasNext()) {
            Space entitySpace;
            ContentEntityObject contentEntityObject = (ContentEntityObject)iterator.next();
            if (contentEntityObject instanceof SpaceContentEntityObject) {
                SpaceContentEntityObject spaceContentEntityObject = (SpaceContentEntityObject)contentEntityObject;
                entitySpace = spaceContentEntityObject.getSpace();
            } else {
                if (!(contentEntityObject instanceof PageContentEntityObject)) continue;
                PageContentEntityObject pageContentEntityObject = (PageContentEntityObject)contentEntityObject;
                entitySpace = pageContentEntityObject.getPage().getSpace();
            }
            if (entitySpace == null || !entitySpace.isPersonal()) continue;
            iterator.remove();
        }
        return contentList;
    }

    public List getAllChangeReports(Date fromWhen) {
        ArrayList<ChangeDigestReport> reports = new ArrayList<ChangeDigestReport>();
        List updatedContent = this.getContentCreatedOrUpdatedSinceDate(fromWhen);
        if (updatedContent.size() == 0) {
            return updatedContent;
        }
        List notifications = this.notificationManager.getDailyReportNotifications();
        for (Notification notification : notifications) {
            ChangeDigestReport changeReport;
            User user = this.userAccessor.getUser(notification.getUserName());
            if (user == null) {
                log.warn((Object)("User " + notification.getUserName() + " not found for notification " + notification + " (removing notification)"));
                this.notificationManager.removeNotification(notification);
                continue;
            }
            if (!this.permissionManager.hasPermission(user, Permission.VIEW, PermissionManager.TARGET_APPLICATION) || !(changeReport = this.getAllChangeReportForUser(user, updatedContent)).hasChanges()) continue;
            reports.add(changeReport);
        }
        return reports;
    }

    private boolean userHasAccessTo(User user, ContentEntityObject entity) {
        if (GeneralUtil.isSuperUser(user)) {
            return true;
        }
        return this.permissionManager.hasPermission(user, Permission.VIEW, entity);
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }
}

