/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.concurrent.Lock;
import com.atlassian.confluence.core.ConfluenceException;
import com.atlassian.confluence.mail.MailAccount;
import com.atlassian.confluence.mail.MailAccountManager;
import com.atlassian.confluence.mail.MailContentManager;
import com.atlassian.confluence.mail.MailPollResult;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.core.exception.InfrastructureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Category;

public class DefaultMailAccountManager
implements MailAccountManager {
    private static final Category log = Category.getInstance(DefaultMailAccountManager.class);
    private static final String MAIL_TIMEOUT_MILLIS = "60000";
    private ClusterManager clusterManager;
    private BandanaManager bandanaManager;
    private MailContentManager mailContentManager;
    private SpaceManager spaceManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailPollResult updateAccountStatus(MailAccount mailAccount) {
        Store store = null;
        String mailAccountNameAndDescription = mailAccount.getName() + " (" + mailAccount.getDescription() + ")";
        try {
            store = this.getStore(mailAccount);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), e.getCause());
            MailPollResult mailPollResult = MailPollResult.failure(mailAccountNameAndDescription, e.getMessage());
            return mailPollResult;
        }
        finally {
            this.closeStore(store);
        }
        return MailPollResult.success(mailAccountNameAndDescription, 0);
    }

    public List poll(Space space) {
        List accounts = this.getMailAccounts(space);
        ArrayList<MailPollResult> results = new ArrayList<MailPollResult>(accounts.size());
        for (MailAccount mailAccount : accounts) {
            if (!mailAccount.isEnabled()) continue;
            results.add(this.poll(space, mailAccount));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailPollResult poll(Space space, MailAccount mailAccount) {
        String mailAccountNameAndDescription = mailAccount.getName() + " (" + mailAccount.getDescription() + ")";
        Lock lock = this.clusterManager.getLock(mailAccount.lockName());
        if (!lock.tryLock()) {
            return MailPollResult.failure(mailAccountNameAndDescription, "Account is already being polled");
        }
        try {
            if (!mailAccount.isEnabled()) {
                MailPollResult mailPollResult = MailPollResult.failure(mailAccountNameAndDescription, "Account is not enabled");
                return mailPollResult;
            }
            MailPollResult mailPollResult = this.retrieveMessages(space, mailAccount);
            return mailPollResult;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailPollResult retrieveMessages(Space space, MailAccount mailAccount) throws MessagingException {
        Store store = null;
        Folder folder = null;
        try {
            store = this.getStore(mailAccount);
        }
        catch (Exception e) {
            log.error((Object)("Error connecting to " + mailAccount + " for space " + space.getKey() + ": " + e.getMessage()), e.getCause());
            MailPollResult mailPollResult = MailPollResult.failure(mailAccount.getName() + " (" + mailAccount.getDescription() + ")", e.getMessage());
            this.closeFolder(folder);
            this.closeStore(store);
            return mailPollResult;
        }
        try {
            folder = store.getFolder(mailAccount.getFolderName());
            folder.open(2);
            Message[] messages = folder.getMessages();
            int newMsgs = messages.length;
            log.debug((Object)("There are " + newMsgs + " messages in the INBOX for Pop Account: " + mailAccount.getName()));
            for (int i = 0; i < messages.length; ++i) {
                MimeMessage msg = (MimeMessage)messages[i];
                try {
                    this.mailContentManager.storeIncomingMail(space, msg);
                }
                catch (ConfluenceException e) {
                    log.warn((Object)("Could not store message within Confluence: [" + msg + "] - this message will be left on the server"), (Throwable)e);
                    continue;
                }
                this.deleteMessageFromServer(msg);
            }
            MailPollResult mailPollResult = MailPollResult.success(mailAccount.getName() + " (" + mailAccount.getDescription() + ")", newMsgs);
            this.closeFolder(folder);
            this.closeStore(store);
            return mailPollResult;
        }
        catch (Throwable throwable) {
            this.closeFolder(folder);
            this.closeStore(store);
            throw throwable;
        }
    }

    public List getMailAccounts(Space space) {
        List accounts = (List)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(space), "atlassian.confluence.space.mailaccounts", false);
        if (accounts == null) {
            return new ArrayList();
        }
        return new ArrayList(accounts);
    }

    public MailAccount addMailAccount(Space space, MailAccount mailAccount) {
        List mailAccounts = this.getMailAccounts(space);
        int id = 1;
        for (MailAccount account : mailAccounts) {
            if (account.getId() < id) continue;
            id = account.getId() + 1;
        }
        mailAccount.setId(id);
        mailAccounts.add(mailAccount);
        this.persistAccounts(space, mailAccounts);
        return mailAccount;
    }

    public void removeMailAccount(Space space, int accountId) {
        List mailAccounts = this.getMailAccounts(space);
        mailAccounts.remove(this.getMailAccount(space, accountId));
        this.persistAccounts(space, mailAccounts);
    }

    public void setMailContentManager(MailContentManager mailContentManager) {
        this.mailContentManager = mailContentManager;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public MailAccount getMailAccount(Space space, int accountId) {
        for (MailAccount account : this.getMailAccounts(space)) {
            if (account.getId() != accountId) continue;
            return account;
        }
        return null;
    }

    private void persistAccounts(Space space, List newMailAccounts) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(space), "atlassian.confluence.space.mailaccounts", (Object)newMailAccounts);
    }

    public void updateAccount(Space space, MailAccount mailAccount) {
        List mailAccounts = this.getMailAccounts(space);
        mailAccounts.remove(this.getMailAccount(space, mailAccount.getId()));
        mailAccounts.add(mailAccount);
        this.persistAccounts(space, mailAccounts);
    }

    public List pollAllSpaces() {
        ArrayList results = new ArrayList();
        for (Space space : this.spaceManager.getSpacesByType(SpaceType.GLOBAL)) {
            results.addAll(this.poll(space));
        }
        return results;
    }

    private Store getStore(MailAccount mailAccount) {
        try {
            Properties props = new Properties();
            props.setProperty("mail.imap.timeout", MAIL_TIMEOUT_MILLIS);
            props.setProperty("mail.imap.connectiontimeout", MAIL_TIMEOUT_MILLIS);
            props.setProperty("mail.pop3.timeout", MAIL_TIMEOUT_MILLIS);
            props.setProperty("mail.pop3.connectiontimeout", MAIL_TIMEOUT_MILLIS);
            Session session = Session.getInstance((Properties)props, null);
            Store store = session.getStore(mailAccount.getProtocol());
            store.connect(mailAccount.getHostname(), mailAccount.getPort(), mailAccount.getUsername(), mailAccount.getPassword());
            mailAccount.setStatus(store.isConnected());
            if (mailAccount.getStatus()) {
                return store;
            }
            throw new InfrastructureException("Unknown error connecting to mail account: " + mailAccount);
        }
        catch (NoSuchProviderException e) {
            throw new InfrastructureException("Configuration error: Javamail could not find provider", (Throwable)e);
        }
        catch (Throwable t) {
            throw new InfrastructureException("Error connecting to mail server: " + t.getMessage(), t);
        }
    }

    private void deleteMessageFromServer(MimeMessage msg) throws MessagingException {
        try {
            msg.setFlag(Flags.Flag.DELETED, true);
        }
        catch (MessagingException e) {
            log.error((Object)("Could not delete email with messageId [" + msg.getMessageID() + "] from " + this + "\nPlease delete this message manually, as too many undeleteable messages will slow down Confluence"));
        }
    }

    private void closeFolder(Folder folder) {
        try {
            if (folder != null) {
                folder.close(true);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error closing folder", (Throwable)e);
        }
    }

    private void closeStore(Store store) {
        try {
            if (store != null) {
                store.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error closing store", (Throwable)e);
        }
    }
}

