/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail;

import com.atlassian.confluence.core.ConfluenceException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultContentEntityManager;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.event.events.content.mail.MailCreateEvent;
import com.atlassian.confluence.event.events.content.mail.MailRemoveEvent;
import com.atlassian.confluence.event.events.content.mail.MailUpdateEvent;
import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.mail.MailContentManager;
import com.atlassian.confluence.mail.persistence.dao.MailDao;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.event.Event;
import com.atlassian.mail.MailUtils;
import com.opensymphony.util.TextUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Category;

public class DefaultMailContentManager
extends DefaultContentEntityManager
implements MailContentManager {
    public static final Category log = Category.getInstance(DefaultMailContentManager.class);
    private AttachmentManager attachmentManager;

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public Mail getMailById(long id) {
        return (Mail)this.getById(id);
    }

    public Iterator getSpaceMailIterator(String spaceKey) {
        return this.getMailDao().getSpaceMailIterator(spaceKey);
    }

    public Iterator getSpaceMailWithAttachmentsIterator(String spaceKey) {
        return this.getMailDao().getSpaceMailWithAttachmentsIterator(spaceKey);
    }

    public List getSpaceMail(int firstResult, int maxResults, String spaceKey) {
        return this.getMailDao().getSpaceMail(firstResult, maxResults, spaceKey);
    }

    public int findMailTotal(Space space) {
        return this.getMailDao().findMailTotal(space);
    }

    public List getMail(Space space, boolean currentOnly) {
        return this.getMailDao().getMail(space, currentOnly);
    }

    public Mail getMailByMessageId(String messageId) {
        return this.getMailDao().getMailByMessageId(messageId);
    }

    public List getMailsByMessageId(String messageId) {
        return this.getMailDao().getMailsByMessageId(messageId);
    }

    public Mail storeIncomingMail(Space space, byte[] rawMessage) {
        try {
            return this.storeIncomingMail(space, new MimeMessage(null, (InputStream)new ByteArrayInputStream(rawMessage)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn((Object)("Could not parse supplied mail message " + e.getMessage()), (Throwable)e);
            throw new InfrastructureException("Could not parse incoming mail: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean spaceHasMail(String spaceKey) {
        return this.getMailDao().getMostRecentMail(spaceKey) != null;
    }

    public Mail getFirstMailAfter(String spaceKey, long mailId) {
        return this.getMailDao().getFirstMailAfter(spaceKey, mailId);
    }

    public Mail getFirstMailBefore(String spaceKey, long mailId) {
        return this.getMailDao().getFirstMailBefore(spaceKey, mailId);
    }

    public void removeMail(Mail mail) {
        this.removeAttachmentsForMail(mail);
        this.removeContentEntity(mail);
    }

    public void removeAllMail(Space space) {
        Iterator mailWithAttachmentsIterator = this.getSpaceMailWithAttachmentsIterator(space.getKey());
        while (mailWithAttachmentsIterator.hasNext()) {
            Mail mailWithAttachments = (Mail)mailWithAttachmentsIterator.next();
            this.removeAttachmentsForMail(mailWithAttachments);
        }
        for (Mail mail : new ArrayList(this.getMail(space, false))) {
            this.removeContentEntity(mail);
        }
    }

    public void removeAttachmentsForMail(Mail mail) {
        for (Attachment attachment : mail.getLatestVersionsOfAttachments()) {
            this.attachmentManager.removeAttachmentFromServer(attachment);
        }
    }

    public Mail getMailItemFromSpace(Space space, String messageId) {
        Mail mailItem = null;
        List currentMail = this.getMail(space, true);
        for (int i = 0; i < currentMail.size() && mailItem == null; ++i) {
            Mail m = (Mail)currentMail.get(i);
            if (m == null || m.getMessageId() == null || !m.getMessageId().equals(messageId)) continue;
            mailItem = m;
        }
        return mailItem;
    }

    public Mail storeIncomingMail(Space space, MimeMessage mimeMessage) throws ConfluenceException {
        String messageId = null;
        try {
            messageId = mimeMessage.getMessageID();
        }
        catch (MessagingException e) {
            log.warn((Object)("Cannot access messageId in mimeMessage (MessageId = " + messageId + ")"), (Throwable)e);
        }
        catch (NullPointerException e) {
            log.warn((Object)("mimeMessage is null: mimeMessage: [" + mimeMessage + "]"), (Throwable)e);
        }
        Mail mail = this.getMailItemFromSpace(space, messageId);
        if (mail != null) {
            return mail;
        }
        try {
            mail = new Mail();
            MimeMessage storedMimeMessage = new MimeMessage((Session)null);
            this.copyHeaders(mimeMessage, storedMimeMessage);
            String body = MailUtils.getBody((Message)mimeMessage);
            storedMimeMessage.setContent((Object)TextUtils.noNull((String)body), "text/plain; charset=UTF-8; format=flowed");
            mail.setMimeMessage(storedMimeMessage);
            mail.setSpace(space);
            if (messageId != null && messageId.length() > 255) {
                messageId = messageId.substring(0, 255);
            }
            mail.setMessageId(messageId);
            this.saveContentEntity(mail, null);
            this.addAttachments(mail, MailUtils.getAttachments((Message)mimeMessage));
            return mail;
        }
        catch (Exception e) {
            log.warn((Object)("Could not store mail message " + e.getMessage()), (Throwable)e);
            throw new ConfluenceException("Could not store incoming mail: " + e.getMessage(), e);
        }
    }

    protected void publishCreateEvent(ContentEntityObject obj) {
        this.eventManager.publishEvent((Event)new MailCreateEvent(this, (Mail)obj));
    }

    protected void publishRemoveEvent(ContentEntityObject obj) {
        this.eventManager.publishEvent((Event)new MailRemoveEvent(this, (Mail)obj));
    }

    protected void publishUpdateEvent(ContentEntityObject obj, ContentEntityObject origObj, SaveContext saveContext) {
        this.eventManager.publishEvent((Event)new MailUpdateEvent(this, (Mail)obj, (Mail)origObj));
    }

    private void addAttachments(Mail mail, MailUtils.Attachment[] attachments) throws IOException {
        for (int i = 0; i < attachments.length; ++i) {
            MailUtils.Attachment mailAttachment = attachments[i];
            Attachment attachment = new Attachment();
            String filename = this.stripInvalidFilenameCharacters(mailAttachment.getFilename());
            if (TextUtils.stringSet((String)filename)) {
                attachment.setFileName(filename);
            } else {
                attachment.setFileName("unnamed-" + i);
            }
            attachment.setContentType(mailAttachment.getContentType());
            attachment.setFileSize(mailAttachment.getContents().length);
            mail.addAttachment(attachment);
            this.attachmentManager.saveAttachment(attachment, null, new ByteArrayInputStream(mailAttachment.getContents()));
        }
    }

    private String stripInvalidFilenameCharacters(String filename) {
        if (!TextUtils.stringSet((String)filename)) {
            return filename;
        }
        StringBuffer result = new StringBuffer();
        char[] stringAsChars = filename.toCharArray();
        int prevChar = 0;
        int length = 0;
        for (int i = 0; i < stringAsChars.length && length <= 255; ++i) {
            int c = stringAsChars[i];
            if (c == 92 || c == 47 || c == 58 || c == 42 || c == 63 || c == 34 || c == 60 || c == 62 || c == 124 || c == 61 || c == 32 && prevChar == 32) continue;
            result.append((char)c);
            ++length;
            prevChar = c;
        }
        return result.toString();
    }

    private void copyHeaders(MimeMessage from, MimeMessage to) throws MessagingException {
        Enumeration headers = from.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            if (header.getName().equalsIgnoreCase("Content-Transfer-Encoding")) continue;
            to.setHeader(header.getName(), header.getValue());
        }
    }

    private MailDao getMailDao() {
        return (MailDao)this.contentEntityObjectDao;
    }
}

