/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail;

import com.atlassian.bonnie.LuceneUtils;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.document.Document;

public class ThreadNode {
    private long mailId;
    private String title;
    private String messageId;
    private String from;
    private String canonicalSubject;
    private Date date;
    private ThreadNode parent;
    private Set children = new TreeSet(new Comparator(){

        public int compare(Object o1, Object o2) {
            ThreadNode t1 = (ThreadNode)o1;
            ThreadNode t2 = (ThreadNode)o2;
            if (t1.equals(t2)) {
                return 0;
            }
            if (t1.getDate() == null || t2.getDate() == null) {
                if (t1.getDate() == t2.getDate()) {
                    return System.identityHashCode(t1) - System.identityHashCode(t2);
                }
                if (t1.getDate() == null) {
                    return -1;
                }
                return 1;
            }
            int comparison = t1.getDate().compareTo(t2.getDate());
            if (comparison == 0) {
                return System.identityHashCode(t1) - System.identityHashCode(t2);
            }
            return comparison;
        }
    });

    public static ThreadNode getEmptyThreadNode() {
        return new ThreadNode(0L, null);
    }

    public ThreadNode(long mailId, Document doc) {
        if (doc != null) {
            this.mailId = mailId;
            this.title = doc.get("title");
            this.messageId = doc.get("messageid");
            this.from = doc.get("from");
            this.canonicalSubject = doc.get("canonicalsubject");
            this.date = LuceneUtils.stringToDate((String)doc.get("created"));
        }
    }

    public boolean isEmpty() {
        return this.mailId == 0L;
    }

    public long getMailId() {
        if (this.mailId == 0L) {
            return System.identityHashCode(this);
        }
        return this.mailId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getFrom() {
        return this.from;
    }

    public Date getDate() {
        return this.date;
    }

    public ThreadNode getParent() {
        return this.parent;
    }

    public void setParent(ThreadNode parent) {
        if (parent != null) {
            if (this.conflicts(parent)) {
                return;
            }
            parent.getChildren().add(this);
        }
        this.parent = parent;
    }

    public Set getChildren() {
        return this.children;
    }

    public void setChildren(Set children) {
        this.children = children;
    }

    public ThreadNode getNodeWithMessageId(String messageId) {
        if (messageId.equals(this.messageId)) {
            return this;
        }
        for (ThreadNode child : this.children) {
            ThreadNode found = child.getNodeWithMessageId(messageId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public int getVisibleThreadCount() {
        int count = 1;
        if (this.getParent() != null) {
            count += this.getParent().getChildren().size();
            if (this.getParent().getParent() != null) {
                ++count;
            }
        }
        return count += this.getChildren().size();
    }

    public int getDescendentsCount() {
        int descendentsCount = this.getChildren().size();
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            descendentsCount += ((ThreadNode)it.next()).getDescendentsCount();
        }
        return descendentsCount;
    }

    boolean descendentHasId(String otherMessageId) {
        if (this.messageId != null && this.messageId.equals(otherMessageId)) {
            return true;
        }
        for (ThreadNode node : this.children) {
            if (!node.descendentHasId(otherMessageId)) continue;
            return true;
        }
        return false;
    }

    boolean ancestorHasId(String otherMessageId) {
        if (this.messageId != null && this.messageId.equals(otherMessageId)) {
            return true;
        }
        return this.parent != null && this.parent.ancestorHasId(otherMessageId);
    }

    private boolean conflicts(ThreadNode parent) {
        return this.descendentHasId(parent.getMessageId()) || this.ancestorHasId(parent.getMessageId()) || parent.descendentHasId(this.messageId) || parent.ancestorHasId(this.messageId);
    }

    public boolean isIsolated() {
        return this.parent == null && this.children.isEmpty();
    }

    public String getCanonicalSubject() {
        return this.canonicalSubject;
    }
}

