/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.actions;

import com.atlassian.confluence.core.actions.RssDescriptor;
import com.atlassian.confluence.mail.MailAccountManager;
import com.atlassian.confluence.mail.MailContentManager;
import com.atlassian.confluence.mail.MailPollResult;
import com.atlassian.confluence.pages.actions.AbstractPaginatedListAction;
import com.atlassian.confluence.themes.MailHelper;
import com.atlassian.confluence.util.GeneralUtil;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Address;

public class ViewMailArchiveAction
extends AbstractPaginatedListAction {
    private static final String PLUGIN_KEY = "space-mails";
    MailAccountManager mailAccountManager;
    MailContentManager mailContentManager;
    boolean polling;
    List pollResults;
    MailHelper mailHelper = new MailHelper();

    public String execute() throws Exception {
        if (this.getSpace() == null || this.getSpace().isPersonal() || this.settingsManager.getGlobalSettings().isSharedMode()) {
            return "pagenotfound";
        }
        GeneralUtil.setCookie("confluence.browse.space.cookie", PLUGIN_KEY);
        this.getPaginationSupport().setTotal(this.mailContentManager.findMailTotal(this.getSpace()));
        return super.execute();
    }

    public String poll() throws Exception {
        this.pollResults = this.mailAccountManager.poll(this.getSpace());
        this.polling = true;
        return this.execute();
    }

    public List getPaginatedMail(int startIndex) {
        return this.mailContentManager.getSpaceMail(startIndex, 30, this.getSpaceKey());
    }

    public String getSender(Address[] addresses) {
        return this.mailHelper.getSender(addresses);
    }

    public List getItems() {
        if (this.mailContentManager.spaceHasMail(this.getSpace().getKey())) {
            return this.mailContentManager.getMail(this.getSpace(), true);
        }
        return new ArrayList();
    }

    public boolean hasMailAccounts() {
        return this.mailAccountManager.getMailAccounts(this.getSpace()).size() > 0;
    }

    public void setMailAccountManager(MailAccountManager mailAccountManager) {
        this.mailAccountManager = mailAccountManager;
    }

    public void setMailContentManager(MailContentManager mailContentManager) {
        this.mailContentManager = mailContentManager;
    }

    public RssDescriptor getRssDescriptor() {
        String title = this.getSpace().getName() + " " + this.getText("recent.mail");
        return new RssDescriptor("/spaces/createrssfeed.action?types=mail&spaces=" + GeneralUtil.urlEncode(this.getKey()) + "&sort=modified&title=" + GeneralUtil.urlEncode(title) + "&maxResults=15", title, this.getRemoteUser() != null);
    }

    public boolean isPolling() {
        return this.polling;
    }

    public List getPollResults() {
        return this.pollResults;
    }

    public boolean isPollSuccessful() {
        for (MailPollResult mailPollResult : this.pollResults) {
            if (mailPollResult.isSuccess()) continue;
            return false;
        }
        return true;
    }
}

