/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.jobs;

import com.atlassian.confluence.mail.template.MailNotificationQueueItem;
import com.atlassian.core.task.Task;
import com.atlassian.core.task.TaskQueueWithErrorQueue;
import com.atlassian.quartz.jobs.AbstractJob;
import com.atlassian.spring.container.ContainerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Category;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ClearOldMailErrors
extends AbstractJob {
    private transient Category log = Category.getInstance(ClearOldMailErrors.class);

    public void doExecute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        TaskQueueWithErrorQueue queue = (TaskQueueWithErrorQueue)ContainerManager.getInstance().getContainerContext().getComponent((Object)"mailTaskQueue");
        ArrayList<MailNotificationQueueItem> newerItems = new ArrayList<MailNotificationQueueItem>();
        Collection errorItems = queue.getErrorQueue().getTasks();
        for (MailNotificationQueueItem errorItem : errorItems) {
            if (new Date().getTime() - errorItem.getDateQueued().getTime() < 172800000L) {
                newerItems.add(errorItem);
                continue;
            }
            this.log.info((Object)("removing item from error queue:" + errorItem.getSubject()));
        }
        queue.getErrorQueue().clear();
        for (MailNotificationQueueItem item : newerItems) {
            queue.getErrorQueue().addTask((Task)item);
        }
    }
}

