/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.jobs;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.mail.ChangeDigestNotificationBean;
import com.atlassian.confluence.mail.reports.ChangeDigestReport;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.quartz.jobs.AbstractJob;
import com.atlassian.user.User;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DailyReportJob
extends AbstractJob {
    public static final String TEMPLATE_NAME = "changedigest-notification.vm";
    private transient Category log = Category.getInstance(DailyReportJob.class);
    private MultiQueueTaskManager taskManager;
    private ChangeDigestNotificationBean changeNotificationBean;
    private UserAccessor userAccessor;
    private FormatSettingsManager formatSettingsManager;

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setTaskManager(MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void setChangeNotificationBean(ChangeDigestNotificationBean changeNotificationBean) {
        this.changeNotificationBean = changeNotificationBean;
    }

    public void setFormatSettingsManager(FormatSettingsManager formatSettingsManager) {
        this.formatSettingsManager = formatSettingsManager;
    }

    public void doExecute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Date date = new Date(System.currentTimeMillis() - 86400000L);
        String subject = GeneralUtil.getI18n().getText("daily.report.title");
        List reports = this.changeNotificationBean.getAllChangeReports(date);
        if (reports.size() > 0) {
            ChangeDigestReport report = null;
            Iterator iter = reports.iterator();
            while (iter.hasNext()) {
                try {
                    report = (ChangeDigestReport)iter.next();
                    if (StringUtils.isBlank((String)report.getUser().getEmail())) {
                        this.log.warn((Object)("Not sending notification email [ " + subject + "+ ] to [ " + report.getUser().getFullName() + " ]:  No email set"));
                        continue;
                    }
                    PreRenderedMailNotificationQueueItem queueItem = (PreRenderedMailNotificationQueueItem)PreRenderedMailNotificationQueueItem.createFromTemplateFile(report.getUser(), TEMPLATE_NAME, subject);
                    queueItem.addVelocityContextParam("report", report);
                    queueItem.addVelocityContextParam("dateFormatter", this.getDateFormatter(report.getUser()));
                    queueItem.render();
                    this.log.debug((Object)("Adding daily report email for user: " + report.getUser().getEmail() + " onto the queue."));
                    this.taskManager.addTask("mail", (Task)queueItem);
                }
                catch (Exception e) {
                    if (report != null) {
                        this.log.error((Object)("Failed to create daily report for user " + report.getUser().getName()), (Throwable)e);
                        continue;
                    }
                    this.log.error((Object)"Error creating daily report", (Throwable)e);
                }
            }
        } else {
            this.log.info((Object)"Nobody awaiting notifications");
        }
    }

    private DateFormatter getDateFormatter(User user) {
        return this.userAccessor.getConfluenceUserPreferences(user).getDateFormatter(this.formatSettingsManager);
    }
}

