/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.notification.listeners;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.mail.notification.listeners.NotificationsPermissionsCheck;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.event.EventListener;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractNotificationsListener
implements EventListener {
    private static final Logger log = Logger.getLogger(AbstractNotificationsListener.class);
    protected UserAccessor userAccessor;
    protected MultiQueueTaskManager taskManager;
    protected NotificationManager notificationManager;
    protected PermissionManager permissionManager;
    protected WikiStyleRenderer wikiStyleRenderer;
    private FormatSettingsManager formatSettingsManager;
    private WebResourceManager webResourceManager;

    protected void sendNotification(Notification notification, NotificationData notificationData) {
        try {
            HashMap<String, Object> contextMap = new HashMap<String, Object>(notificationData.getContext());
            User toUser = this.userAccessor.getUser(notification.getUserName());
            if (toUser == null || this.userAccessor.isDeactivated(toUser) || !notificationData.getPermissionsCheck().shouldNotify(toUser)) {
                return;
            }
            contextMap.put("remoteUser", toUser);
            contextMap.put("webResourceManager", this.webResourceManager);
            contextMap.put("dateFormatter", this.userAccessor.getConfluenceUserPreferences(toUser).getDateFormatter(this.formatSettingsManager));
            contextMap.put("wikiStyleRenderer", this.wikiStyleRenderer);
            contextMap.put("i18nBean", GeneralUtil.getI18n());
            String renderedSubject = VelocityUtils.getRenderedContent(notificationData.getSubject(), contextMap);
            if (StringUtils.isBlank((String)toUser.getEmail())) {
                log.warn((Object)("Not sending notification email [ " + renderedSubject + " ] to [ " + toUser.getFullName() + " ]:  No email set"));
                return;
            }
            this.taskManager.addTask("mail", (Task)this.createNotificationTask(toUser, notificationData, renderedSubject, contextMap));
        }
        catch (Throwable t) {
            log.error((Object)"Error sending notification", t);
        }
    }

    protected MailQueueItem createNotificationTask(User toUser, NotificationData notificationData, String renderedSubject, Map contextMap) {
        return PreRenderedMailNotificationQueueItem.createFromTemplateFileAndContext(toUser, notificationData.getTemplateName(), renderedSubject, contextMap);
    }

    protected void sendPageNotifications(AbstractPage page, NotificationData notificationData) {
        List pageNotifications = this.notificationManager.getNotificationsByPage(page);
        this.sendNotifications(pageNotifications, notificationData);
    }

    protected void sendSpaceNotifications(Space space, NotificationData notificationData) {
        List spaceNotifications = this.notificationManager.getNotificationsBySpace(space);
        this.sendNotifications(spaceNotifications, notificationData);
    }

    protected void sendNotifications(List spaceNotifications, NotificationData notificationData) {
        for (Notification notification : spaceNotifications) {
            if (!notificationData.doNotNotifyAgain(notification.getUserName())) {
                this.sendNotification(notification, notificationData);
            }
            notificationData.addDoNotNotifyAgain(notification.getUserName());
        }
    }

    protected NotificationsPermissionsCheck makeViewEntityPermissionsCheck(final Object entity) {
        return new NotificationsPermissionsCheck(){

            public boolean shouldNotify(User user) {
                return AbstractNotificationsListener.this.permissionManager.hasPermission(user, Permission.VIEW, entity);
            }
        };
    }

    protected User getLastModifier(ConfluenceEntityObject entity) {
        User modifier = null;
        if (TextUtils.stringSet((String)entity.getLastModifierName())) {
            modifier = this.userAccessor.getUser(entity.getLastModifierName());
        }
        return modifier;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setTaskManager(MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setFormatSettingsManager(FormatSettingsManager formatSettingsManager) {
        this.formatSettingsManager = formatSettingsManager;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }
}

