/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.notification.listeners;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.mail.notification.listeners.AbstractNotificationsListener;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.Event;
import com.atlassian.user.User;

public class AttachmentNotificationsListener
extends AbstractNotificationsListener {
    public static final Class[] HANDLED_EVENTS = new Class[]{AttachmentCreateEvent.class, AttachmentRemoveEvent.class};

    public void handleEvent(Event event) {
        AttachmentEvent attachmentEvent = (AttachmentEvent)event;
        ContentEntityObject attachedTo = attachmentEvent.getContent();
        if (attachedTo instanceof AbstractPage) {
            AbstractPage page = (AbstractPage)attachedTo;
            Space space = page.getSpace();
            Attachment firstAttachment = (Attachment)attachmentEvent.getAttachments().get(0);
            User modifier = this.getLastModifier(firstAttachment);
            NotificationData notificationData = new NotificationData(modifier);
            notificationData.addToContext("page", page);
            notificationData.addToContext("space", space);
            notificationData.addToContext("attachments", attachmentEvent.getAttachments());
            notificationData.setPermissionsCheck(this.makeViewEntityPermissionsCheck(firstAttachment));
            notificationData.setSubject("$space.name > $page.title");
            if (event instanceof AttachmentCreateEvent) {
                notificationData.setTemplateName("attachfile-notification.vm");
            } else if (event instanceof AttachmentRemoveEvent) {
                notificationData.setTemplateName("removefile-notification.vm");
                notificationData.addToContext("remover", ((AttachmentRemoveEvent)event).getOriginatingUser());
            }
            this.sendSpaceNotifications(space, notificationData);
            this.sendPageNotifications(page, notificationData);
        }
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_EVENTS;
    }
}

