/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.notification.listeners;

import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.mail.notification.listeners.AbstractNotificationsListener;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.Event;
import com.atlassian.user.User;

public class BlogPostNotificationsListener
extends AbstractNotificationsListener {
    public static final Class[] HANDLED_EVENTS = new Class[]{BlogPostCreateEvent.class, BlogPostUpdateEvent.class, BlogPostTrashedEvent.class};

    public void handleEvent(Event event) {
        BlogPostEvent blogEvent = (BlogPostEvent)event;
        BlogPost blog = blogEvent.getBlogPost();
        Space space = blog.getSpace();
        User modifier = this.getLastModifier(blog);
        NotificationData notificationData = new NotificationData(modifier);
        notificationData.setPermissionsCheck(this.makeViewEntityPermissionsCheck(blog));
        notificationData.addToContext("blog", blog);
        notificationData.addToContext("space", space);
        boolean shouldNotify = true;
        notificationData.setSubject("$space.name > $blog.title");
        if (event instanceof BlogPostCreateEvent) {
            notificationData.setTemplateName("createblogpost-notification.vm");
        } else if (event instanceof BlogPostTrashedEvent) {
            notificationData.setTemplateName("removeblogpost-notification.vm");
            notificationData.addToContext("trasher", ((BlogPostTrashedEvent)event).getOriginatingUser());
        } else if (((BlogPostUpdateEvent)event).isMinorEdit()) {
            shouldNotify = false;
        } else {
            BlogPostUpdateEvent updateEvent = (BlogPostUpdateEvent)event;
            notificationData.addToContext("originalBlogPost", updateEvent.getOriginalBlogPost());
            notificationData.setTemplateName("editblogpost-notification.vm");
        }
        if (shouldNotify) {
            this.sendSpaceNotifications(space, notificationData);
            this.sendPageNotifications(blog, notificationData);
        }
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_EVENTS;
    }
}

