/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.notification.listeners;

import com.atlassian.confluence.mail.notification.listeners.NotificationsPermissionsCheck;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotificationData {
    private Map context = new HashMap();
    private String templateName;
    private String subject;
    private User modifier;
    private List doNotNotifyAgain = new ArrayList();
    private NotificationsPermissionsCheck permissionsCheck;
    private UserAccessor userAccessor;

    public NotificationData(User modifier) {
        this.modifier = modifier;
        if (modifier != null) {
            this.context.put("modifier", modifier);
            if (!new UserPreferences(this.getUserAccessor().getPropertySet(modifier)).getBoolean("confluence.prefs.notify.for.my.own.actions")) {
                this.doNotNotifyAgain.add(modifier.getName());
            }
        }
    }

    public Map getContext() {
        return this.context;
    }

    public void addToContext(String key, Object value) {
        this.context.put(key, value);
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getSubject() {
        return this.subject;
    }

    public User getModifier() {
        return this.modifier;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public boolean doNotNotifyAgain(String userName) {
        return this.doNotNotifyAgain.contains(userName);
    }

    public void addDoNotNotifyAgain(String userName) {
        this.doNotNotifyAgain.add(userName);
    }

    public void setPermissionsCheck(NotificationsPermissionsCheck permissionsCheck) {
        this.permissionsCheck = permissionsCheck;
    }

    public NotificationsPermissionsCheck getPermissionsCheck() {
        return this.permissionsCheck;
    }

    public UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

