/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.notification.listeners;

import com.atlassian.confluence.event.events.space.SpaceUpdateEvent;
import com.atlassian.confluence.mail.notification.listeners.AbstractNotificationsListener;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.Event;
import com.atlassian.renderer.RenderContext;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;

public class SpaceNotificationsListener
extends AbstractNotificationsListener {
    public static final Class[] HANDLED_EVENTS = new Class[]{SpaceUpdateEvent.class};

    public void handleEvent(Event event) {
        SpaceUpdateEvent spaceEvent = (SpaceUpdateEvent)event;
        Space space = spaceEvent.getSpace();
        User modifier = this.getLastModifier(space);
        NotificationData notificationData = new NotificationData(modifier);
        notificationData.setPermissionsCheck(this.makeViewEntityPermissionsCheck(space));
        notificationData.addToContext("space", space);
        if (TextUtils.stringSet((String)space.getDescription().getContent())) {
            notificationData.addToContext("renderedDescription", this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new PageContext(space.getKey()), space.getDescription().getContent()));
        }
        notificationData.setTemplateName("editspace-notification.vm");
        notificationData.setSubject("$i18nBean.getText(\"email.notification.editspace.title\"): $space.name ($space.key)");
        this.sendSpaceNotifications(space, notificationData);
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_EVENTS;
    }
}

