/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.reports;

import com.atlassian.confluence.mail.reports.AbstractContentEntityReport;
import com.atlassian.confluence.mail.reports.ChangeDigestReport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import java.util.HashSet;
import java.util.Set;

public class CommentReport
extends AbstractContentEntityReport {
    private int count;
    private AbstractPage page;
    private Set commentAuthors = new HashSet();

    public CommentReport(Comment comment, ChangeDigestReport report) {
        super(comment, report);
        this.page = comment.getPage();
        this.count = 1;
        this.addCommentAuthor(comment.getCreatorName());
    }

    public AbstractPage getPage() {
        return this.page;
    }

    public long getPageId() {
        return this.page.getId();
    }

    public void incrementCount() {
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }

    public void addCommentAuthor(String author) {
        if (author != null) {
            this.commentAuthors.add(author);
        } else {
            this.commentAuthors.add("Anonymous");
        }
    }

    public Set getCommentAuthors() {
        return this.commentAuthors;
    }
}

