/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.reports;

import com.atlassian.confluence.mail.reports.ChangeDigestReport;
import com.atlassian.confluence.mail.reports.CommentReport;
import com.atlassian.confluence.mail.reports.PageReport;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SpaceReport {
    private Space space;
    private final List pages;
    private final List comments;
    private Date refDate;
    private ChangeDigestReport parentReport;

    public SpaceReport(Space space, ChangeDigestReport report) {
        this.space = space;
        this.parentReport = report;
        this.refDate = new Date(System.currentTimeMillis() - this.parentReport.getCoverPeriod());
        this.pages = new ArrayList();
        this.comments = new ArrayList();
    }

    public Space getSpace() {
        return this.space;
    }

    public boolean isNewForPeriod() {
        return this.refDate.before(this.getCreationDate());
    }

    public ChangeDigestReport getParentReport() {
        return this.parentReport;
    }

    public String getCreatorName() {
        return this.space.getCreatorName();
    }

    public User getCreator() {
        return this.parentReport.getUserAccessor().getUser(this.getCreatorName());
    }

    public Date getCreationDate() {
        return this.space.getCreationDate();
    }

    public Date getLastModificationDate() {
        return this.space.getLastModificationDate();
    }

    public long getId() {
        return this.space.getId();
    }

    public String getLastModifierName() {
        return this.space.getLastModifierName();
    }

    public User getLastModifier() {
        return this.parentReport.getUserAccessor().getUser(this.getLastModifierName());
    }

    public String getKey() {
        return this.space.getKey();
    }

    public String getName() {
        return this.space.getName();
    }

    public void addPage(PageReport page) {
        this.pages.add(page);
    }

    public void removePage(PageReport page) {
        this.pages.remove(page);
    }

    public void addBlogPost(PageReport page) {
        this.pages.add(page);
    }

    public List getPages() {
        return this.pages;
    }

    public void addComment(CommentReport commentReport) {
        for (CommentReport existingReport : this.comments) {
            long commentReportPageId;
            long existingReportPageId = existingReport.getPageId();
            if (existingReportPageId != (commentReportPageId = commentReport.getPageId())) continue;
            existingReport.incrementCount();
            existingReport.addCommentAuthor(commentReport.getCreatorName());
            return;
        }
        this.comments.add(commentReport);
    }

    public List getComments() {
        return this.comments;
    }

    public int getChangeSize() {
        return this.pages.size() + this.comments.size();
    }
}

