/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public abstract class AbstractAttachmentManager
implements AttachmentManager {
    private static Logger log = Logger.getLogger(AbstractAttachmentManager.class);
    protected EventManager eventManager;

    public Attachment getAttachment(ContentEntityObject content, String attachmentFileName) {
        return this.getAttachment(content, attachmentFileName, 0);
    }

    public Attachment getAttachment(ContentEntityObject content, String attachmentFileName, int version) {
        if (version <= 0) {
            for (Attachment attachment : this.getLatestVersionsOfAttachments(content)) {
                if (!attachment.getFileName().equalsIgnoreCase(attachmentFileName)) continue;
                return attachment;
            }
        } else {
            for (Attachment attachment : this.getAttachments(content)) {
                if (!attachment.getFileName().equalsIgnoreCase(attachmentFileName) || version != attachment.getVersion()) continue;
                return attachment;
            }
        }
        return null;
    }

    public void saveAttachment(Attachment attachment, Attachment previousVersion, InputStream attachmentData) throws IOException {
        Assert.notNull((Object)attachment, (String)"Attachment");
        Assert.notNull((Object)attachment.getContent(), (String)"Attachment content");
        Assert.notNull((Object)attachment.getContentType(), (String)"Attachment content type");
        if (previousVersion == null) {
            this.saveNewAttachment(attachment, attachmentData);
        } else {
            this.saveNewAttachmentVersion(attachment, previousVersion, attachmentData);
            this.eventManager.publishEvent((Event)new AttachmentUpdateEvent(this, attachment));
        }
    }

    protected abstract void saveNewAttachment(Attachment var1, InputStream var2) throws IOException;

    protected abstract void saveNewAttachmentVersion(Attachment var1, Attachment var2, InputStream var3) throws IOException;

    public void removeAttachments(List attachments) {
        Iterator iter = attachments.iterator();
        while (iter.hasNext()) {
            Object o = null;
            try {
                o = iter.next();
                this.removeAttachmentFromServer((Attachment)o);
            }
            catch (ClassCastException e) {
                log.error((Object)("Not of type Attachment: [" + o.getClass().getName() + "]"), (Throwable)e);
            }
        }
    }

    public List getPreviousVersions(Attachment attachment) {
        List allVersions = this.getAllVersions(attachment);
        allVersions.remove(0);
        return allVersions;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

