/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.pages.AbstractPage;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class BlogPost
extends AbstractPage {
    public static final String CONTENT_TYPE = "blogpost";
    public static final String POSTING_DAY_FORMAT = "yyyy/MM/dd";

    public String getType() {
        return CONTENT_TYPE;
    }

    public static Calendar toCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public String getLinkPart() {
        return "/" + this.getDatePath() + "/" + this.getTitle();
    }

    public String getDatePath() {
        return BlogPost.toDatePath(this.getCreationDate());
    }

    public static String toDatePath(Date date) {
        return new SimpleDateFormat(POSTING_DAY_FORMAT).format(date);
    }

    public String getAttachmentsUrlPath() {
        return "/pages/viewpageattachments.action?pageId=" + this.getId();
    }

    public String getPostingYear() {
        return this.formatPostingDate("yyyy");
    }

    public String getPostingMonth() {
        return this.formatPostingDate("MMMM");
    }

    public String getPostingMonthNumeric() {
        return this.formatPostingDate("MM");
    }

    public String getPostingDayOfMonth() {
        return this.formatPostingDate("dd");
    }

    private String formatPostingDate(String format) {
        if (this.getCreationDate() == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(this.getCreationDate());
    }
}

