/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PageContentEntityObject;
import com.atlassian.confluence.util.GeneralUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Comment
extends PageContentEntityObject {
    public static final String CONTENT_TYPE = "comment";
    private Comment parent;
    private List children = new ArrayList();

    public String getDisplayTitle() {
        if (this.getOriginalVersion() != null) {
            return ((ContentEntityObject)this.getOriginalVersion()).getDisplayTitle();
        }
        if (this.getPage() == null) {
            return "Erroneous orphaned comment";
        }
        return "Re: " + this.getPage().getTitle();
    }

    public String getUrlPath() {
        return GeneralUtil.customGetPageUrl(this.getPage()) + "focusedCommentId=" + this.getId() + "#comment-" + this.getId();
    }

    public String getType() {
        return CONTENT_TYPE;
    }

    public String getNameForComparison() {
        return this.getPage().getTitle();
    }

    public String getSpaceKey() {
        return this.getPage().getSpaceKey();
    }

    public Comment getParent() {
        return this.parent;
    }

    public void setParent(Comment parent) {
        this.parent = parent;
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
    }

    public void addChild(Comment child) {
        this.children.add(child);
        child.setParent(this);
        this.getPage().addComment(child);
    }

    public int getDescendantsCount() {
        int descendants = 0;
        for (Comment child : this.children) {
            ++descendants;
            descendants += child.getDescendantsCount();
        }
        return descendants;
    }

    public Set getDescendantAuthors() {
        HashSet<String> authors = new HashSet<String>();
        for (Comment child : this.children) {
            authors.add(child.getCreatorName());
            authors.addAll(child.getDescendantAuthors());
        }
        return authors;
    }

    public int getDepth() {
        if (this.parent == null) {
            return 0;
        }
        return 1 + this.parent.getDepth();
    }

    public Date getThreadChangedDate() {
        Date date = this.getCreationDate();
        for (Comment child : this.children) {
            Date childChangedDate = child.getThreadChangedDate();
            if (childChangedDate == null || date != null && !childChangedDate.after(date)) continue;
            date = childChangedDate;
        }
        return date;
    }

    public void reparentChildren(Comment newParent) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            Comment child = (Comment)it.next();
            if (newParent != null) {
                newParent.addChild(child);
            } else {
                child.setParent(null);
            }
            it.remove();
        }
    }

    public void convertToHistoricalVersion() {
        super.convertToHistoricalVersion();
        this.children = new ArrayList();
        this.parent = null;
    }

    public void removeChild(Comment child) {
        if (child.getParent() != null && child.getParent().equals(this)) {
            child.setParent(null);
            this.children.remove(child);
        }
    }
}

