/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.Page;
import java.util.ArrayList;
import java.util.List;

public class ContentTree {
    List rootContentNodes = new ArrayList();

    public ContentTree() {
    }

    public ContentTree(List rootContentNodes) {
        if (rootContentNodes != null) {
            this.rootContentNodes = rootContentNodes;
        }
    }

    public List getRootNodes() {
        return this.rootContentNodes;
    }

    public boolean isRootNode(ContentNode node) {
        return this.rootContentNodes.contains(node);
    }

    public void filter(List ids) {
        List allContentNodes = this.getAllContentNodes();
        for (ContentNode contentNode : allContentNodes) {
            String contentNodeId = String.valueOf(contentNode.getPage().getId());
            if (ids.contains(contentNodeId)) continue;
            this.removeNode(contentNode);
        }
    }

    public void addRootNode(ContentNode contentNode) {
        contentNode.setParent(null);
        this.rootContentNodes.add(contentNode);
    }

    public void removeNode(ContentNode contentNode) {
        if (this.isRootNode(contentNode)) {
            for (ContentNode childContentNode : contentNode.getChildren()) {
                this.addRootNode(childContentNode);
            }
            this.rootContentNodes.remove(contentNode);
        } else {
            contentNode.getParent().addChildren(contentNode.getChildren());
            contentNode.getParent().removeChild(contentNode);
        }
    }

    public List getAllContentNodes() {
        ArrayList allContentNodes = new ArrayList();
        for (ContentNode contentNode : this.rootContentNodes) {
            this.collectChildNodes(allContentNodes, contentNode);
        }
        return allContentNodes;
    }

    public List getPages() {
        ArrayList<Page> pages = new ArrayList<Page>();
        for (ContentNode contentNode : this.getAllContentNodes()) {
            pages.add(contentNode.getPage());
        }
        return pages;
    }

    public int size() {
        return this.getAllContentNodes().size();
    }

    private void collectChildNodes(List allContentNodes, ContentNode contentNode) {
        allContentNodes.add(contentNode);
        if (contentNode.getChildren().size() > 0) {
            for (ContentNode childNode : contentNode.getChildren()) {
                this.collectChildNodes(allContentNodes, childNode);
            }
        }
    }
}

