/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ListQuery;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.pages.AbstractAttachmentManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentDataExistsException;
import com.atlassian.confluence.pages.AttachmentDataNotFoundException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.DelegatingAttachmentManager;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.pages.persistence.dao.GeneralAttachmentCopier;
import com.atlassian.confluence.pages.persistence.dao.GeneralAttachmentMigrator;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.Event;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAttachmentManager
extends AbstractAttachmentManager {
    private static Logger log = Logger.getLogger(DefaultAttachmentManager.class);
    private AttachmentDao attachmentDao;

    @Override
    public InputStream getAttachmentData(Attachment attachment) {
        try {
            return this.attachmentDao.getAttachmentData(attachment);
        }
        catch (AttachmentDataNotFoundException e) {
            String cause = e.getMessage();
            if (e.getCause() != null) {
                cause = e.getCause().toString();
            }
            log.error((Object)("Could not find data for attachment: " + attachment.toString() + " - " + cause));
            return null;
        }
    }

    @Override
    protected void saveNewAttachment(Attachment attachment, InputStream attachmentData) throws IOException {
        this.attachmentDao.saveNewAttachment(attachment, attachmentData);
    }

    @Override
    protected void saveNewAttachmentVersion(Attachment attachment, Attachment previousVersion, InputStream attachmentData) throws IOException {
        this.attachmentDao.saveNewAttachmentVersion(attachment, previousVersion, attachmentData);
    }

    @Override
    public List<Attachment> getLatestVersionsOfAttachments(ContentEntityObject content) {
        return this.attachmentDao.getLatestVersionsOfAttachments(content);
    }

    @Override
    public List getAttachments(ContentEntityObject content) {
        return content.getAttachments();
    }

    @Override
    public List getAttachments(ListQuery query, int firstResult) {
        return this.attachmentDao.getAttachmentByQuery(query, firstResult);
    }

    @Override
    public void removeAttachmentFromServer(Attachment latestVersion) {
        this.eventManager.publishEvent((Event)new AttachmentRemoveEvent((Object)this, latestVersion, AuthenticatedUserThreadLocal.getUser()));
        List allVersions = this.getAllVersions(latestVersion);
        Collections.reverse(allVersions);
        for (Attachment attachment : allVersions) {
            attachment.setOriginalVersion(null);
            this.attachmentDao.removeAttachmentFromServer(attachment);
        }
    }

    @Override
    public void moveAttachment(Attachment latestVersion, String newFileName, ContentEntityObject newContent) {
        Attachment oldAttachment;
        ContentEntityObject oldContent = latestVersion.getContent();
        try {
            oldAttachment = (Attachment)latestVersion.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)"Attachment object does not support cloning", (Throwable)e);
            throw new RuntimeException(e);
        }
        oldContent.removeAttachment(latestVersion);
        newContent.addAttachment(latestVersion);
        latestVersion.setFileName(newFileName);
        for (Attachment attachment : this.getAllVersions(latestVersion)) {
            attachment.setFileName(newFileName);
            oldContent.removeAttachment(attachment);
            newContent.addAttachment(attachment);
        }
        this.attachmentDao.moveAttachment(latestVersion, oldAttachment, newContent);
    }

    @Override
    public void setAttachmentData(Attachment attachment, InputStream attachmentData) throws AttachmentDataExistsException {
        try {
            this.attachmentDao.getAttachmentData(attachment);
            throw new AttachmentDataExistsException("Attachment data was found for attachment '" + attachment + "'. Cannot set new data.");
        }
        catch (AttachmentDataNotFoundException attachmentDataNotFoundException) {
            this.attachmentDao.replaceAttachmentData(attachment, attachmentData);
            return;
        }
    }

    @Override
    public AttachmentDao.AttachmentMigrator getMigrator(AttachmentManager destination) {
        if (destination instanceof DelegatingAttachmentManager) {
            destination = ((DelegatingAttachmentManager)((Object)destination)).getAttachmentManager();
        }
        if (this.getClass().equals(destination.getClass())) {
            return this.attachmentDao.getMigrator(destination.getAttachmentDao());
        }
        return new GeneralAttachmentMigrator(this, destination);
    }

    @Override
    public AttachmentDao.AttachmentCopier getCopier(AttachmentManager destination) {
        if (destination instanceof DelegatingAttachmentManager) {
            destination = ((DelegatingAttachmentManager)((Object)destination)).getAttachmentManager();
        }
        if (this.getClass().equals(destination.getClass())) {
            return this.attachmentDao.getCopier(destination.getAttachmentDao());
        }
        return new GeneralAttachmentCopier(this, destination);
    }

    @Override
    public AttachmentDao getAttachmentDao() {
        return this.attachmentDao;
    }

    @Override
    public List getAllVersions(Attachment attachment) {
        return this.attachmentDao.findAllVersions(attachment);
    }

    public void setAttachmentDao(AttachmentDao attachmentDao) {
        this.attachmentDao = attachmentDao;
    }
}

