/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BreadcrumbsManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.opensymphony.webwork.ServletActionContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Category;

public class DefaultBreadcrumbsManager
implements BreadcrumbsManager {
    public static final Category log = Category.getInstance(DefaultBreadcrumbsManager.class);
    private SettingsManager settingsManager;
    private PageManager pageManager;
    private static final String BREADCRUMB_DELIMITER = "&nbsp;&gt;&nbsp;";

    private String expandEllipsisForPage(Page p, HttpServletRequest request) {
        return this.getHTMLBreadcrumbs(this.getHiddenAncestors(p), request);
    }

    public String generateAncestryBreadcrumbsForPage(long pageId) {
        try {
            String breadcrumb = "";
            AbstractPage abstractPage = this.pageManager.getAbstractPage(pageId);
            if (abstractPage instanceof Page) {
                Page page = (Page)abstractPage;
                List ancestors = page.getAncestors();
                HttpServletRequest request = ServletActionContext.getRequest();
                if (ancestors.size() == 1) {
                    breadcrumb = this.createPageLink(page.getParent(), request) + BREADCRUMB_DELIMITER;
                } else if (ancestors.size() > 1) {
                    int numberOfParentPages = this.settingsManager.getGlobalSettings().getNumberOfBreadcrumbAncestors();
                    List visibleAncestors = ancestors.subList(Math.max(0, ancestors.size() - numberOfParentPages), ancestors.size());
                    String ancestorBreadcrumb = this.getHTMLBreadcrumbs(visibleAncestors, request);
                    if (ancestors.size() > numberOfParentPages) {
                        breadcrumb = "<span id=\"breadcrumbs\"><span id=\"breadcrumbsEllipsis\"><a href=\"#\" onclick=\"showBreadcrumbsEllipsis();return false;\" title=\"" + this.getTextBreadcrumbs(this.getHiddenAncestors(page)) + "\">...</a></span><span id=\"breadcrumbsExpansion\" style=\"display:none;\">" + this.expandEllipsisForPage(page, request) + "</span>" + BREADCRUMB_DELIMITER + "</span>";
                    }
                    breadcrumb = breadcrumb + ancestorBreadcrumb + BREADCRUMB_DELIMITER;
                }
            }
            return breadcrumb;
        }
        catch (RuntimeException e) {
            log.error((Object)("Error generating breadcrumbs: " + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    private List getHiddenAncestors(Page page) {
        ArrayList ancestors = new ArrayList(page.getAncestors());
        int numberOfParentPages = this.settingsManager.getGlobalSettings().getNumberOfBreadcrumbAncestors();
        return ancestors.subList(0, Math.max(0, ancestors.size() - numberOfParentPages));
    }

    private String getHTMLBreadcrumbs(List pages, HttpServletRequest request) {
        String breadcrumbs = "";
        Iterator iterator = pages.iterator();
        while (iterator.hasNext()) {
            breadcrumbs = breadcrumbs + this.createPageLink((Page)iterator.next(), request) + (iterator.hasNext() ? BREADCRUMB_DELIMITER : "");
        }
        return breadcrumbs;
    }

    private String getTextBreadcrumbs(List pages) {
        String breadcrumbs = "";
        Iterator iterator = pages.iterator();
        while (iterator.hasNext()) {
            Page page = (Page)iterator.next();
            if (page == null) continue;
            breadcrumbs = breadcrumbs + page.getTitle() + (iterator.hasNext() ? BREADCRUMB_DELIMITER : "");
        }
        return breadcrumbs;
    }

    private String createPageLink(Page page, HttpServletRequest request) {
        return "<a href='" + request.getContextPath() + GeneralUtil.getPageUrl(page) + "'>" + page.getTitle() + "</a>";
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }
}

