/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftAjax;
import com.atlassian.confluence.pages.DraftData;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.wysiwyg.ConfluenceWysiwygConverter;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.ajax.AjaxResponse;
import java.util.Date;
import org.apache.log4j.Logger;

public class DefaultDraftAjax
implements DraftAjax {
    private static final Logger log = Logger.getLogger(DefaultDraftAjax.class);
    private ConfluenceWysiwygConverter confluenceWysiwygConverter;
    private DraftManager draftManager;
    private UserAccessor userAccessor;
    private FormatSettingsManager formatSettingsManager;

    public AjaxResponse saveDraft(DraftData draftData, boolean isXhtml) {
        if (draftData == null || draftData.getPageId() == null) {
            log.warn((Object)("Received invalid draft data from the client, discarding: " + draftData));
            return AjaxResponse.failure("Server refused to save draft. Contact admin for details.");
        }
        if (isXhtml) {
            draftData.setContent(this.confluenceWysiwygConverter.convertXHtmlToWikiMarkupWithoutPage(draftData.getContent(), draftData.getPageId()));
        }
        Draft draft = new Draft();
        draft.setTitle(draftData.getTitle());
        draft.setDraftType(draftData.getType());
        draft.setContent(draftData.getContent());
        draft.setDraftSpaceKey(draftData.getSpaceKey());
        draft.setPageVersion(draftData.getPageVersion());
        draft.setPageId(draftData.getPageId());
        draft.setCreatorName(AuthenticatedUserThreadLocal.getUsername());
        this.draftManager.saveDraft(draft);
        DateFormatter dateFormatter = this.userAccessor.getConfluenceUserPreferences(AuthenticatedUserThreadLocal.getUser()).getDateFormatter(this.formatSettingsManager);
        return AjaxResponse.success("{ draftId: " + draft.getIdAsString() + ", time: \"" + dateFormatter.formatTime(new Date()) + "\" }");
    }

    public Draft findDraft(String pageId, String type) {
        return this.draftManager.findDraft(pageId, AuthenticatedUserThreadLocal.getUsername(), type);
    }

    public int getDraftSaveInterval() {
        return this.draftManager.getDraftSaveInterval();
    }

    public void setConfluenceWysiwygConverter(ConfluenceWysiwygConverter confluenceWysiwygConverter) {
        this.confluenceWysiwygConverter = confluenceWysiwygConverter;
    }

    public void setDraftManager(DraftManager draftManager) {
        this.draftManager = draftManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setFormatSettingsManager(FormatSettingsManager formatSettingsManager) {
        this.formatSettingsManager = formatSettingsManager;
    }
}

