/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.persistence.dao.DraftDao;
import com.atlassian.confluence.pages.persistence.dao.SessionDraftDao;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.DiffUtils;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.user.User;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDraftManager
implements DraftManager {
    protected final transient Logger log = Logger.getLogger(this.getClass());
    private DraftDao draftDao;
    private SettingsManager settingsManager;
    private PageManager pageManager;
    private AttachmentManager attachmentManager;
    private HttpContext httpContext;

    @Override
    public void saveDraft(Draft draft) {
        DraftDao dao;
        Draft existingDraft;
        Assert.notNull((Object)draft, (String)"Draft must not be null");
        Assert.hasText((String)draft.getPageId(), (String)"Page ID of draft must not be blank");
        Assert.hasText((String)draft.getDraftType(), (String)"Draft type must not be blank");
        if (!draft.isNewPage()) {
            Assert.notNull((Object)this.getAbstractPage(draft), (String)("Could not find page with ID [" + draft.getPageId() + "] to save draft."));
        }
        if ((existingDraft = (dao = this.getDao(draft.getCreatorName())).getDraft(draft.getPageId(), draft.getCreatorName(), draft.getDraftType())) != null) {
            existingDraft.setContent(draft.getContent());
            existingDraft.setTitle(draft.getTitle());
            existingDraft.setDraftSpaceKey(draft.getDraftSpaceKey());
            dao.saveOrUpdate(existingDraft);
        } else {
            dao.saveOrUpdate(draft);
        }
    }

    private DraftDao getDao(String owner) {
        if (owner == null) {
            HttpSession session = this.httpContext.getSession(true);
            if (session == null) {
                throw new IllegalStateException("Failed to find or create session");
            }
            return new SessionDraftDao(session);
        }
        return this.draftDao;
    }

    @Override
    public Draft findDraft(String pageId, String owner, String type) {
        return this.getDao(owner).getDraft(pageId, owner, type);
    }

    @Override
    public void removeDraft(String pageId, String owner, String type) {
        Draft draft = this.findDraft(pageId, owner, type);
        if (draft != null) {
            this.removeAssociatedAttachments(draft);
            this.getDao(owner).remove(draft);
        }
    }

    private void removeAssociatedAttachments(Draft draft) {
        for (Attachment attachment : this.attachmentManager.getLatestVersionsOfAttachments(draft)) {
            this.attachmentManager.removeAttachmentFromServer(attachment);
        }
    }

    @Override
    public void removeDraftById(long id) {
        this.removeAssociatedAttachments(this.draftDao.getDraft(id));
        this.draftDao.remove(id);
    }

    @Override
    public int getDraftSaveInterval() {
        return this.settingsManager.getGlobalSettings().getDraftSaveInterval();
    }

    @Override
    public List<Draft> findDraftsForUser(User user) {
        String owner = user == null ? null : user.getName();
        return this.getDao(owner).findByCreatorName(owner);
    }

    @Override
    public boolean isMergeRequired(Draft draft) {
        if (draft.isNewPage()) {
            return false;
        }
        AbstractPage page = this.getAbstractPage(draft);
        return page != null && draft.getPageVersion() != page.getVersion();
    }

    @Override
    public String getMergedContent(Draft draft) {
        AbstractPage page = null;
        try {
            page = this.getAbstractPage(draft);
            if (page == null) {
                this.log.warn((Object)("Cannot merge draft because page does not exist: " + draft));
                return null;
            }
            Page originalVersion = (Page)this.pageManager.getOtherVersion(page, draft.getPageVersion());
            if (originalVersion == null) {
                this.log.warn((Object)("Original version of page: " + page + " v." + draft.getPageVersion() + " does not exist. Cannot merge content."));
                return null;
            }
            return DiffUtils.mergeChanges(originalVersion.getContent(), page.getContent(), draft.getContent());
        }
        catch (RuntimeException e) {
            this.log.warn((Object)("Error merging latest version of page with draft: " + draft), (Throwable)e);
            this.log.debug((Object)("Draft contents:\n" + draft.getContent()));
            if (page != null) {
                this.log.debug((Object)("Current page contents:\n" + page.getContent()));
            }
            return null;
        }
    }

    @Override
    public void updateSpaceKey(String newSpaceKey, String oldSpaceKey) {
        this.draftDao.updateSpaceKey(newSpaceKey, oldSpaceKey);
    }

    @Override
    public Draft getOrCreate(String username, String draftType, String spaceKey) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)draftType), (String)"Draft type is required");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)spaceKey), (String)"Space key is required");
        Draft existingDraft = this.findDraft("0", username, draftType);
        if (existingDraft != null) {
            return existingDraft;
        }
        Draft newDraft = new Draft();
        newDraft.setDraftType(draftType);
        newDraft.setDraftSpaceKey(spaceKey);
        newDraft.setCreatorName(username);
        this.saveDraft(newDraft);
        return newDraft;
    }

    @Override
    public void removeAll() {
        String owner = AuthenticatedUserThreadLocal.getUsername();
        DraftDao dao = this.getDao(owner);
        for (Draft draft : dao.findAll()) {
            this.removeAssociatedAttachments(draft);
            dao.remove(draft.getId());
        }
    }

    private AbstractPage getAbstractPage(Draft draft) {
        try {
            ContentEntityObject o = this.pageManager.getById(Long.parseLong(draft.getPageId()));
            if (o instanceof AbstractPage) {
                return (AbstractPage)o;
            }
        }
        catch (NumberFormatException nfe) {
            this.log.error((Object)("Draft has invalid page ID: " + draft));
        }
        return null;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setDraftDao(DraftDao draftDao) {
        this.draftDao = draftDao;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }
}

