/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.UploadedResource;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.xwork.FileUploadUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

public class DefaultFileUploadManager
implements FileUploadManager {
    private AttachmentManager attachmentManager;
    private static Category log = Category.getInstance(DefaultFileUploadManager.class);
    private static final String OCTET_STREAM_MIME_TYPE = "application/octet-stream";

    public Collection verifyFile(String fileName, FileUploadUtils.UploadedFile[] uploadedFiles) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)fileName)) {
            if (fileName.indexOf("&") != -1 || fileName.indexOf("+") != -1 || fileName.indexOf("?") != -1 || fileName.indexOf("|") != -1 || fileName.indexOf("=") != -1) {
                errors.add(fileName + " contains illegal characters. You cannot upload files with names containing '&', '+', '?', '|' or '='");
            }
            boolean valid = false;
            for (int j = 0; j < uploadedFiles.length; ++j) {
                if (!fileName.equals(uploadedFiles[j].getFileName())) continue;
                valid = true;
                break;
            }
            if (!valid) {
                errors.add(fileName + " does not exist.");
            }
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeResource(UploadedResource resource, String comment, ContentEntityObject ceo) {
        String filename = resource.getFilename();
        Attachment attachment = this.attachmentManager.getAttachment(ceo, filename);
        Attachment previousVersion = null;
        if (attachment == null) {
            attachment = new Attachment();
        } else {
            try {
                previousVersion = (Attachment)attachment.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InfrastructureException((Throwable)e);
            }
        }
        String contentType = resource.getContentType();
        attachment.setContentType(StringUtils.isBlank((String)contentType) ? OCTET_STREAM_MIME_TYPE : contentType);
        if (previousVersion != null) {
            attachment.setFileName(previousVersion.getFileName());
        } else {
            attachment.setFileName(filename);
        }
        attachment.setComment(comment);
        attachment.setFileSize(resource.getContentLength());
        InputStream resourceStream = null;
        try {
            ceo.addAttachment(attachment);
            resourceStream = resource.getInputStream();
            this.attachmentManager.saveAttachment(attachment, previousVersion, resourceStream);
        }
        catch (IOException e) {
            try {
                log.error((Object)"Failed to save file.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(resourceStream);
                throw throwable;
            }
            IOUtils.close(resourceStream);
        }
        IOUtils.close(resourceStream);
    }

    public void storeFile(FileUploadUtils.UploadedFile uploadedFile, String comment, ContentEntityObject ceo) {
        this.storeResource(new UploadedResource(uploadedFile), comment, ceo);
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

