/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.core.DefaultContentEntityManager;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageChildrenReorderEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.ChildPositionComparator;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.persistence.dao.AbstractPageDao;
import com.atlassian.confluence.pages.persistence.dao.BlogPostDao;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.event.Event;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPageManager
extends DefaultContentEntityManager
implements PageManager {
    public static final String EXCERPT_KEY = "confluence.excerpt";
    private BlogPostDao blogPostDao;
    private AbstractPageDao abstractPageDao;
    private NotificationManager notificationManager;
    private AttachmentManager attachmentManager;
    private ContentPropertyManager contentPropertyManager;
    private PermissionManager permissionManager;

    @Override
    public void renamePage(AbstractPage page, String newPageTitle) {
        try {
            AbstractPage oldVersion = (AbstractPage)page.clone();
            oldVersion.convertToHistoricalVersion();
            page.setTitle(newPageTitle);
            this.saveContentEntity(page, oldVersion, null);
        }
        catch (CloneNotSupportedException e) {
            throw new InfrastructureException("Couldn't clone page", (Throwable)e);
        }
    }

    @Override
    public List getBlogPosts(Space space, boolean currentOnly) {
        return this.blogPostDao.getBlogPosts(space, currentOnly);
    }

    @Override
    public List getPossibleRedirectsForSpace(Space space, String pageTitle) {
        List possibleRedirects = this.getPageDao().findPagesWithHistoricalTitle(pageTitle);
        ArrayList<Page> pagesToReturn = new ArrayList<Page>();
        for (Page page : possibleRedirects) {
            if (!page.getSpace().getKey().equalsIgnoreCase(space.getKey())) continue;
            pagesToReturn.add(page);
        }
        return pagesToReturn;
    }

    @Override
    public List getPossibleRedirects(String pageTitle) {
        return this.getPageDao().findPagesWithHistoricalTitle(pageTitle);
    }

    @Override
    public List getRecentlyAddedBlogPosts(int maxPosts, Date timeSince, String spaceKey) {
        if (timeSince == null) {
            return this.getRecentlyAddedBlogPosts(maxPosts, spaceKey);
        }
        return this.blogPostDao.getRecentlyAddedBlogPosts(maxPosts, timeSince, spaceKey);
    }

    public void setBlogPostDao(BlogPostDao blogPostDao) {
        this.blogPostDao = blogPostDao;
    }

    @Override
    public Page getPage(long id) {
        return this.getPageDao().getPageById(id);
    }

    @Override
    public AbstractPage getAbstractPage(long id) {
        return this.abstractPageDao.getAbstractPageById(id);
    }

    @Override
    public BlogPost getBlogPost(long id) {
        return this.blogPostDao.getById(id);
    }

    @Override
    public Page getPage(String spaceKey, String pageTitle) {
        return this.getPageDao().getPage(spaceKey, pageTitle);
    }

    @Override
    public Page getPage(String spaceKey, String pageTitle, boolean eagerLoadComments) {
        return this.getPageDao().getPage(spaceKey, pageTitle, eagerLoadComments);
    }

    @Override
    public List getPageInTrash(String spaceKey, String title) {
        return this.getPageDao().getPageInTrash(spaceKey, title);
    }

    @Override
    public boolean spaceHasBlogPosts(String spaceKey) {
        return this.blogPostDao.getMostRecentBlogPost(spaceKey) != null;
    }

    @Override
    public List getDescendents(Page page) {
        return this.getPageDao().getDescendents(page);
    }

    @Override
    public void updatePageInAncestorCollections(Page page, Page newParent) {
        this.removePageFromAncestorCollections(page);
        ArrayList<Page> newAncestors = new ArrayList<Page>();
        if (newParent != null) {
            newAncestors.addAll(newParent.getAncestors());
            newAncestors.add(newParent);
        }
        page.getAncestors().clear();
        page.getAncestors().addAll(newAncestors);
        newAncestors.add(page);
        List descendants = this.getDescendents(page);
        for (Page descendant : descendants) {
            descendant.getAncestors().addAll(0, newAncestors);
        }
    }

    @Override
    public void removePageFromAncestorCollections(Page page) {
        ArrayList<Page> ancestors = new ArrayList<Page>(page.getAncestors());
        ancestors.add(page);
        List descendents = this.getDescendents(page);
        for (Page descendent : descendents) {
            descendent.getAncestors().removeAll(ancestors);
        }
    }

    @Override
    public void removeAllPages(Space space) {
        for (Page page : new ArrayList(this.getPages(space, false))) {
            page.remove(this);
        }
    }

    @Override
    public void removeAllBlogPosts(Space space) {
        for (BlogPost post : new ArrayList(this.getBlogPosts(space, false))) {
            post.remove(this);
        }
    }

    @Override
    public Collection getDescendentIds(Page page) {
        return this.getPageDao().getDescendentIds(page);
    }

    @Override
    public List getTopLevelPages(Space space) {
        return this.getPageDao().getTopLevelPages(space);
    }

    @Override
    public BlogPost findPreviousBlogPost(String key, Date time) {
        return this.blogPostDao.getFirstPostBefore(key, time);
    }

    @Override
    public BlogPost findNextBlogPost(String key, Date time) {
        return this.blogPostDao.getFirstPostAfter(key, time);
    }

    @Override
    public void trashPage(AbstractPage page) {
        page.trash();
        for (Comment comment : page.getComments()) {
            comment.trash();
        }
        this.indexer.unIndexIncludingDependents(page);
        if (page.getType().equals("page")) {
            this.eventManager.publishEvent((Event)new PageTrashedEvent(this, (Page)page, AuthenticatedUserThreadLocal.getUser()));
        } else if (page.getType().equals("blogpost")) {
            this.eventManager.publishEvent((Event)new BlogPostTrashedEvent(this, (BlogPost)page, AuthenticatedUserThreadLocal.getUser()));
        }
    }

    @Override
    public void restorePage(AbstractPage page) {
        page.setContentStatus("current");
        for (Comment comment : page.getComments()) {
            comment.setContentStatus("current");
        }
        this.indexer.indexIncludingDependents(page);
        if (page.getType().equals("page")) {
            this.eventManager.publishEvent((Event)new PageRestoreEvent(this, (Page)page));
        } else if (page.getType().equals("blogpost")) {
            this.eventManager.publishEvent((Event)new BlogPostRestoreEvent(this, (BlogPost)page));
        }
    }

    @Override
    public void movePageToTopLevel(Page page, Space space) {
        Integer oldPosition = page.getPosition();
        Space oldSpace = page.getSpace();
        Page oldParent = page.getParent();
        this.updatePageInAncestorCollections(page, null);
        this.movePageToSpace(page, space);
        this.setPositionIfNeeded(page, this.getTopLevelPages(space));
        if (oldParent != null) {
            oldParent.removeChild(page);
            this.contentEntityObjectDao.saveRaw(oldParent);
        }
        this.eventManager.publishEvent((Event)new ContentPermissionEvent(this, page, null));
        this.eventManager.publishEvent((Event)new PageMoveEvent((Object)this, page, oldSpace, oldParent, oldPosition, AuthenticatedUserThreadLocal.getUser()));
    }

    @Override
    public void movePage(Page sourcePage, Space targetSpace) {
        this.movePageToTopLevel(sourcePage, targetSpace);
    }

    private void setPositionIfNeeded(Page sourcePage, List siblingsToBe) {
        if (this.isOrdered(siblingsToBe)) {
            sourcePage.setPosition(siblingsToBe.size());
        }
    }

    @Override
    public void movePageAfter(Page page, Page refPage) {
        this.movePageBeforeOrAfter(page, refPage, "below");
    }

    @Override
    public void movePageBefore(Page page, Page refPage) {
        this.movePageBeforeOrAfter(page, refPage, "above");
    }

    @Override
    public void movePage(Page page, Page refPage, int offset) {
        this.movePageBeforeOrAfter(page, refPage, offset > 0 ? "below" : "above");
    }

    private void movePageBeforeOrAfter(Page sourcePage, Page targetPage, String position) {
        Space oldSpace = sourcePage.getSpace();
        Page oldParent = sourcePage.getParent();
        Integer oldPosition = sourcePage.getPosition();
        this.updatePageInAncestorCollections(sourcePage, targetPage.getParent());
        this.movePageToSpace(sourcePage, targetPage.getSpace());
        TreeSet<Page> updatedPages = new TreeSet<Page>();
        updatedPages.add(targetPage);
        updatedPages.add(sourcePage);
        Page newParent = targetPage.getParent();
        sourcePage.setParentPage(newParent);
        if (oldParent != null && !oldParent.equals(newParent)) {
            oldParent.removeChild(sourcePage);
            updatedPages.add(oldParent);
        }
        if (newParent != null && !newParent.equals(oldParent)) {
            newParent.addChild(sourcePage);
            updatedPages.add(newParent);
        }
        updatedPages.addAll(this.setTargetSiblingPositions(sourcePage, targetPage, position));
        this.saveUpdatedPages(updatedPages);
        this.eventManager.publishEvent((Event)new PageMoveEvent((Object)this, sourcePage, oldSpace, oldParent, oldPosition, AuthenticatedUserThreadLocal.getUser()));
        this.eventManager.publishEvent((Event)new ContentPermissionEvent(this, sourcePage, null));
    }

    private List<Page> setTargetSiblingPositions(Page sourcePage, Page targetPage, String position) {
        List<Page> targetSiblings = this.getSiblings(targetPage);
        targetSiblings.remove(sourcePage);
        this.applyPositions(targetSiblings, true);
        int offset = position.equals("above") ? 0 : 1;
        int newPosition = targetPage.getPosition() + offset;
        targetSiblings.add(newPosition, sourcePage);
        this.applyPositions(targetSiblings, false);
        return targetSiblings;
    }

    private void applyPositions(List<Page> siblings, boolean sort) {
        if (sort) {
            Collections.sort(siblings, new ChildPositionComparator());
        }
        int position = 0;
        for (Page page : siblings) {
            page.setPosition(position++);
        }
    }

    private List<Page> getSiblings(Page page) {
        if (page.getParent() == null) {
            return new ArrayList<Page>(this.getTopLevelPages(page.getSpace()));
        }
        return new ArrayList<Page>(page.getParent().getChildren());
    }

    private boolean isOrdered(List<Page> pages) {
        if (pages.isEmpty()) {
            return false;
        }
        LinkedList<Integer> positions = new LinkedList<Integer>();
        for (Page page : pages) {
            Integer position = page.getPosition();
            if (position == null || positions.contains(position)) {
                return false;
            }
            positions.add(position);
        }
        return true;
    }

    @Override
    public void movePageAsChild(Page page, Page newParent) {
        Space oldSpace = page.getSpace();
        Page oldParent = page.getParent();
        Integer oldPosition = page.getPosition();
        this.updatePageInAncestorCollections(page, newParent);
        this.movePageToSpace(page, newParent.getSpace());
        TreeSet<Page> updatedPages = new TreeSet<Page>();
        updatedPages.add(newParent);
        updatedPages.add(page);
        if (oldParent != null) {
            updatedPages.add(oldParent);
            oldParent.removeChild(page);
        }
        List targetSiblings = newParent.getChildren();
        boolean targetOrdered = this.isOrdered(targetSiblings);
        newParent.addChild(page);
        if (targetOrdered) {
            this.applyPositions(targetSiblings, false);
            updatedPages.addAll(targetSiblings);
        }
        this.saveUpdatedPages(updatedPages);
        this.eventManager.publishEvent((Event)new PageMoveEvent((Object)this, page, oldSpace, oldParent, oldPosition, AuthenticatedUserThreadLocal.getUser()));
    }

    @Override
    public void appendPage(Page sourcePage, Page targetParent) {
        this.movePageAsChild(sourcePage, targetParent);
    }

    @Override
    public void setChildPageOrder(Page parentPage, List<Long> childIds) {
        List oldSortedChildren = parentPage.getSortedChildren();
        ArrayList<Page> newSortedChildren = new ArrayList<Page>(childIds.size());
        for (int newPosition = 0; newPosition < childIds.size(); ++newPosition) {
            long id = childIds.get(newPosition);
            Page childPage = (Page)this.abstractPageDao.getAbstractPageById(id);
            childPage.setPosition(newPosition);
            this.contentEntityObjectDao.saveRaw(childPage);
            newSortedChildren.add(childPage);
        }
        this.eventManager.publishEvent((Event)new PageChildrenReorderEvent(this, parentPage, oldSortedChildren, newSortedChildren, AuthenticatedUserThreadLocal.getUser()));
    }

    @Override
    public void revertChildPageOrder(Page parentPage) {
        List oldSortedChildren = parentPage.getSortedChildren();
        for (Page childPage : oldSortedChildren) {
            childPage.setPosition(null);
            this.contentEntityObjectDao.saveRaw(childPage);
        }
        List newSortedChildren = parentPage.getSortedChildren();
        this.eventManager.publishEvent((Event)new PageChildrenReorderEvent(this, parentPage, oldSortedChildren, newSortedChildren, AuthenticatedUserThreadLocal.getUser()));
    }

    private void movePageToSpace(Page sourcePage, Space targetSpace) {
        if (sourcePage.getSpace().equals(targetSpace)) {
            return;
        }
        this.updateOutgoingLinksInContent(sourcePage, targetSpace.getKey(), false);
        this.updateContentLinkingTo(sourcePage, targetSpace.getKey(), null, false);
        sourcePage.setSpace(targetSpace);
        User user = AuthenticatedUserThreadLocal.getUser();
        LinkedList children = new LinkedList(sourcePage.getChildren());
        for (Page child : children) {
            if (!this.getPermissionManager().hasPermission(user, Permission.EDIT, child)) {
                List siblingsToBe = this.getTopLevelPages(child.getSpace());
                sourcePage.removeChild(child);
                this.setPositionIfNeeded(child, siblingsToBe);
                continue;
            }
            this.movePageToSpace(child, targetSpace);
        }
        this.contentEntityObjectDao.saveRaw(sourcePage);
        List attachments = sourcePage.getAttachments();
        for (Attachment a : attachments) {
            this.indexer.reIndex((Searchable)a);
        }
    }

    private void saveUpdatedPages(Collection<Page> updatedPages) {
        for (Page updatedPage : updatedPages) {
            this.contentEntityObjectDao.saveRaw(updatedPage);
        }
    }

    @Override
    public AbstractPage getPageByVersion(AbstractPage mostRecentPage, int version) {
        return (AbstractPage)this.getOtherVersion(mostRecentPage, version);
    }

    @Override
    public BlogPost getBlogPost(String spaceKey, String postTitle, Calendar day) {
        return this.blogPostDao.getBlogPost(spaceKey, postTitle, day);
    }

    @Override
    public BlogPost getBlogPost(String spaceKey, String postTitle, Calendar day, boolean eagerLoadComments) {
        return this.blogPostDao.getBlogPost(spaceKey, postTitle, day, eagerLoadComments);
    }

    @Override
    public List getRecentlyAddedBlogPosts(int maxCount, String spaceKey) {
        return this.blogPostDao.getRecentlyAddedBlogPosts(maxCount, spaceKey);
    }

    @Override
    public List getRecentlyAddedPages(int maxCount, String spaceKey) {
        return this.getPageDao().getRecentlyAddedPages(maxCount, spaceKey);
    }

    @Override
    public List getRecentlyUpdatedPages(int maxCount, String spaceKey) {
        return this.getPageDao().getRecentlyUpdatedPages(maxCount, spaceKey);
    }

    @Override
    public List getOrphanedPages(String spaceKey) {
        return this.getPageDao().getOrphanedPages(spaceKey);
    }

    @Override
    public List getUndefinedPages(String spaceKey) {
        List result = this.getPageDao().getUndefinedPages(spaceKey);
        result = this.filterOutProfileLinks(result);
        return this.filterOutEscapedLinks(result);
    }

    private List filterOutEscapedLinks(List result) {
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            OutgoingLink outgoingLink = (OutgoingLink)iterator.next();
            if (!outgoingLink.getDestinationPageTitle().endsWith("\\")) continue;
            iterator.remove();
        }
        return result;
    }

    private List filterOutProfileLinks(List result) {
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            OutgoingLink outgoingLink = (OutgoingLink)iterator.next();
            if (!outgoingLink.getDestinationPageTitle().startsWith("~")) continue;
            iterator.remove();
        }
        return result;
    }

    @Override
    public List getPermissionPages(Space space) {
        ArrayList<Page> result = new ArrayList<Page>();
        for (Page page : this.getPageDao().getPermissionPages(space)) {
            if (page.getPermissions().isEmpty()) continue;
            result.add(page);
        }
        return result;
    }

    @Override
    public void saveContentEntity(ContentEntityObject obj, ContentEntityObject origObj, SaveContext saveContext) {
        if (obj instanceof AbstractPage && !obj.getTitle().equals(origObj.getTitle())) {
            AbstractPage page = (AbstractPage)obj;
            String newTitle = page.getTitle();
            page.setTitle(origObj.getTitle());
            if (page instanceof Page) {
                this.getPageDao().removeFromPageKeyCache(page.getSpace().getKey(), page.getTitle());
            }
            this.updateContentLinkingTo(page, null, newTitle);
            String updatedContent = this.linkManager.getContentWithRenamedLinks(page, page, null, newTitle);
            page.setContent(updatedContent);
            page.setTitle(newTitle);
        }
        super.saveContentEntity(obj, origObj, saveContext);
        if (this.contentPropertyManager.getTextProperty(obj, EXCERPT_KEY) != null) {
            this.contentPropertyManager.setTextProperty(obj, EXCERPT_KEY, "");
        }
    }

    @Override
    protected void publishCreateEvent(ContentEntityObject obj) {
        if (obj instanceof Page) {
            this.eventManager.publishEvent((Event)new PageCreateEvent(this, (Page)obj));
        } else if (obj instanceof BlogPost) {
            this.eventManager.publishEvent((Event)new BlogPostCreateEvent(this, (BlogPost)obj));
        }
    }

    @Override
    protected void publishUpdateEvent(ContentEntityObject obj, ContentEntityObject origObj, SaveContext saveContext) {
        if (obj instanceof Page) {
            if (saveContext != null) {
                this.eventManager.publishEvent((Event)new PageUpdateEvent(this, (Page)obj, (Page)origObj, saveContext.isMinorEdit()));
            } else {
                this.eventManager.publishEvent((Event)new PageUpdateEvent(this, (Page)obj, (Page)origObj));
            }
        } else if (obj instanceof BlogPost) {
            if (saveContext != null) {
                this.eventManager.publishEvent((Event)new BlogPostUpdateEvent(this, (BlogPost)obj, (BlogPost)origObj, saveContext.isMinorEdit()));
            } else {
                this.eventManager.publishEvent((Event)new BlogPostUpdateEvent(this, (BlogPost)obj, (BlogPost)origObj));
            }
        }
    }

    @Override
    protected void publishRemoveEvent(ContentEntityObject obj) {
        if (obj instanceof Page) {
            this.eventManager.publishEvent((Event)new PageRemoveEvent(this, (Page)obj));
        } else if (obj instanceof BlogPost) {
            this.eventManager.publishEvent((Event)new BlogPostRemoveEvent(this, (BlogPost)obj));
        }
    }

    @Override
    public int getAuthoredPagesCountByUser(String username) {
        return this.getPageDao().getAuthoredPagesCountByUser(username);
    }

    @Override
    public List getPagesCreatedOrUpdatedSinceDate(Date previousLoginDate) {
        return this.getPageDao().getPagesCreatedOrUpdatedSinceDate(previousLoginDate);
    }

    @Override
    public List getBlogPosts(String spaceKey, Calendar postingDate, int period) {
        return this.blogPostDao.getBlogPosts(spaceKey, postingDate, period);
    }

    @Override
    public List getPages(Space space, boolean currentOnly) {
        return this.getPageDao().getPages(space, currentOnly);
    }

    @Override
    public List getPagesStartingWith(Space space, String s) {
        return this.getPageDao().getPagesStartingWith(space, s);
    }

    @Override
    public BlogPost findPreviousBlogPost(BlogPost post) {
        return this.blogPostDao.getFirstPostBefore(post);
    }

    @Override
    public BlogPost findNextBlogPost(BlogPost post) {
        return this.blogPostDao.getFirstPostAfter(post);
    }

    @Override
    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @Override
    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @Override
    public AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    @Override
    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    @Override
    public void setIndexer(ConfluenceIndexer indexer) {
        this.indexer = indexer;
    }

    public void setContentPropertyManager(ContentPropertyManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    public void setAbstractPageDao(AbstractPageDao abstractPageDao) {
        this.abstractPageDao = abstractPageDao;
    }

    public PermissionManager getPermissionManager() {
        if (this.permissionManager == null) {
            this.permissionManager = (PermissionManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"permissionManager");
        }
        return this.permissionManager;
    }
}

