/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.cluster.ClusterConfigurationHelper;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ListQuery;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentDataExistsException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.DelegatingAttachmentManager;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.setup.settings.SettingsManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatorAttachmentManager
implements AttachmentManager,
DelegatingAttachmentManager {
    private SettingsManager settingsManager;
    private ClusterConfigurationHelper clusterConfigurationHelper;
    private AttachmentManager webDavAttachmentManager;
    private AttachmentManager defaultAttachmentManager;
    private AttachmentManager databaseAttachmentManager;
    private AttachmentManager clusterAttachmentManager;

    @Override
    public AttachmentManager getAttachmentManager() {
        String currentSetting = this.settingsManager.getGlobalSettings().getAttachmentDataStore();
        if (this.settingsManager.getGlobalSettings().getWebdavServerUrl() != null && currentSetting == null || "webdav.based.attachments.storage".equals(currentSetting)) {
            return this.webDavAttachmentManager;
        }
        if (this.clusterConfigurationHelper.isClusteredInstance()) {
            return this.clusterAttachmentManager;
        }
        if ("database.based.attachments.storage".equals(currentSetting)) {
            return this.databaseAttachmentManager;
        }
        return this.defaultAttachmentManager;
    }

    @Override
    public List getAttachments(ContentEntityObject content) {
        return this.getAttachmentManager().getAttachments(content);
    }

    @Override
    public List getAttachments(ListQuery query, int firstResult) {
        return this.getAttachmentManager().getAttachments(query, firstResult);
    }

    @Override
    public List<Attachment> getLatestVersionsOfAttachments(ContentEntityObject content) {
        return this.getAttachmentManager().getLatestVersionsOfAttachments(content);
    }

    @Override
    public Attachment getAttachment(ContentEntityObject content, String attachmentFileName, int version) {
        return this.getAttachmentManager().getAttachment(content, attachmentFileName, version);
    }

    @Override
    public Attachment getAttachment(ContentEntityObject content, String attachmentFileName) {
        return this.getAttachmentManager().getAttachment(content, attachmentFileName);
    }

    @Override
    public InputStream getAttachmentData(Attachment attachment) {
        return this.getAttachmentManager().getAttachmentData(attachment);
    }

    @Override
    public void removeAttachmentFromServer(Attachment attachment) {
        this.getAttachmentManager().removeAttachmentFromServer(attachment);
    }

    @Override
    public void saveAttachment(Attachment attachment, Attachment previousVersion, InputStream attachmentData) throws IOException {
        this.getAttachmentManager().saveAttachment(attachment, previousVersion, attachmentData);
    }

    @Override
    public void setAttachmentData(Attachment attachment, InputStream attachmentData) throws AttachmentDataExistsException {
        this.getAttachmentManager().setAttachmentData(attachment, attachmentData);
    }

    @Override
    public void moveAttachment(Attachment attachment, String newFileName, ContentEntityObject newName) {
        this.getAttachmentManager().moveAttachment(attachment, newFileName, newName);
    }

    @Override
    public List getAllVersions(Attachment attachment) {
        return this.getAttachmentManager().getAllVersions(attachment);
    }

    @Override
    public List getPreviousVersions(Attachment attachment) {
        return this.getAttachmentManager().getPreviousVersions(attachment);
    }

    @Override
    public void removeAttachments(List attachments) {
        this.getAttachmentManager().removeAttachments(attachments);
    }

    @Override
    public AttachmentDao.AttachmentMigrator getMigrator(AttachmentManager destination) {
        return this.getAttachmentManager().getMigrator(destination);
    }

    @Override
    public AttachmentDao.AttachmentCopier getCopier(AttachmentManager destination) {
        return this.getAttachmentManager().getCopier(destination);
    }

    @Override
    public AttachmentDao getAttachmentDao() {
        AttachmentDao dao = this.getAttachmentManager().getAttachmentDao();
        return dao;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setClusterConfigurationHelper(ClusterConfigurationHelper clusterConfigurationHelper) {
        this.clusterConfigurationHelper = clusterConfigurationHelper;
    }

    public void setWebDavAttachmentManager(AttachmentManager webDavAttachmentManager) {
        this.webDavAttachmentManager = webDavAttachmentManager;
    }

    public void setDefaultAttachmentManager(AttachmentManager defaultAttachmentManager) {
        this.defaultAttachmentManager = defaultAttachmentManager;
    }

    public void setDatabaseAttachmentManager(AttachmentManager databaseAttachmentManager) {
        this.databaseAttachmentManager = databaseAttachmentManager;
    }

    public void setClusterAttachmentManager(AttachmentManager clusterAttachmentManager) {
        this.clusterAttachmentManager = clusterAttachmentManager;
    }
}

