/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.confluence.core.Hierarchical;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.ChildPositionComparator;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Page
extends AbstractPage
implements Hierarchical {
    public static final String CONTENT_TYPE = "page";
    private Page parent;
    private List children = new ArrayList();
    private List ancestors = new ArrayList();
    private Integer position;
    public static final Comparator pageComparator = new ChildPositionComparator();

    public void setPosition(Integer position) {
        this.position = position;
    }

    public void incPosition() {
        this.position = new Integer(this.position + 1);
    }

    public Integer getPosition() {
        return this.position;
    }

    public boolean isRootLevel() {
        return this.parent == null;
    }

    public Page getParent() {
        return this.parent;
    }

    public void setParent(Page parent) {
        this.parent = parent;
    }

    public void setParentPage(Page parent) {
        this.checkParentValid(parent);
        this.parent = parent;
    }

    private void checkParentValid(Page parent) {
        boolean parentInSameSpace;
        if (parent == null) {
            return;
        }
        if (parent == this || this.getId() != 0L && parent.getId() == this.getId()) {
            throw new IllegalArgumentException("Can not set page as its own parent.");
        }
        Space parentSpace = parent.getSpace();
        Space childSpace = this.getSpace();
        boolean bl = parentInSameSpace = parentSpace == null || childSpace == null || parentSpace.getKey() == null || childSpace.getKey() == null || parentSpace.getKey().equals(childSpace.getKey());
        if (!parentInSameSpace) {
            throw new IllegalArgumentException("Can't add a parent from another space.");
        }
    }

    public List getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.getChildren() != null && this.getChildren().size() > 0;
    }

    public List getSortedChildren() {
        ArrayList sortedKids = new ArrayList(this.getChildren());
        Collections.sort(sortedKids, pageComparator);
        return sortedKids;
    }

    public void setChildren(List children) {
        this.children = children;
    }

    public void addChild(Page child) {
        if (this.getAncestors().contains(child)) {
            throw new IllegalArgumentException("Cannot add an existing ancestor as a child!");
        }
        this.children.add(child);
        child.setParentPage(this);
        child.getAncestors().addAll(this.getAncestors());
        child.getAncestors().add(this);
    }

    public void removeChild(Page child) {
        child.setParentPage(null);
        this.children.remove(child);
        child.getAncestors().clear();
        child.setPosition(null);
    }

    public boolean isHomePage() {
        return this.getSpace() != null && this.getSpace().getHomePage() != null && this.getSpace().getHomePage().equals(this);
    }

    public String getType() {
        return CONTENT_TYPE;
    }

    public void convertToHistoricalVersion() {
        super.convertToHistoricalVersion();
        this.setChildren(new ArrayList());
        this.setParentPage(null);
        this.setAncestors(new ArrayList());
    }

    public String getNameForComparison() {
        return this.getTitle();
    }

    public void severParentChildRelationships() {
        if (this.getParent() != null) {
            this.getParent().removeChild(this);
        }
        while (!this.getChildren().isEmpty()) {
            Page childPage = (Page)this.getChildren().get(0);
            this.removeChild(childPage);
        }
    }

    public void remove(PageManager pageManager) {
        this.resetCurrentSpaceHomePage(null);
        pageManager.removePageFromAncestorCollections(this);
        this.severParentChildRelationships();
        super.remove(pageManager);
    }

    public void trash() {
        this.severParentChildRelationships();
        super.trash();
    }

    public List getDescendents() {
        ArrayList descendents = new ArrayList();
        this.addDescendents(descendents);
        return descendents;
    }

    private void addDescendents(List descendents) {
        descendents.addAll(this.getChildren());
        for (Page page : this.getChildren()) {
            page.addDescendents(descendents);
        }
    }

    public List getAncestors() {
        return this.ancestors;
    }

    public void setAncestors(List ancestors) {
        this.ancestors = ancestors;
    }

    public void setSpace(Space newSpace) {
        this.resetCurrentSpaceHomePage(newSpace);
        super.setSpace(newSpace);
    }

    private void resetCurrentSpaceHomePage(Space newSpace) {
        Page homePage;
        if (this.getSpace() != null && (!this.getSpace().equals(newSpace) || newSpace == null) && (homePage = this.getSpace().getHomePage()) != null && homePage.equals(this)) {
            this.getSpace().setHomePage(null);
        }
    }
}

