/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages;

import com.atlassian.xwork.FileUploadUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.AbstractResource;

public class UploadedResource
extends AbstractResource {
    private FileUploadUtils.UploadedFile uploadedFile;

    public UploadedResource(FileUploadUtils.UploadedFile uploadedFile) {
        this.uploadedFile = uploadedFile;
    }

    public String getDescription() {
        return "Uploaded file: " + this.getFilename();
    }

    public File getFile() throws IOException {
        return this.uploadedFile.getFile();
    }

    public String getFilename() throws IllegalStateException {
        return this.uploadedFile.getFileName();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.getFile());
    }

    public String getContentType() {
        return this.uploadedFile.getContentType();
    }

    public long getContentLength() {
        try {
            return this.getFile().length();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

