/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractTemplatePageAction;
import com.atlassian.confluence.pages.actions.ActionHelper;
import com.atlassian.confluence.security.CaptchaAware;
import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractCreateAndEditPageAction
extends AbstractTemplatePageAction
implements CaptchaAware {
    protected String parentPageTitle;
    protected String parentPageSpaceKey;
    private Page parentPage;
    protected long parentPageId;
    protected String viewPermissionsGroups;
    protected String viewPermissionsUsers;
    protected String editPermissionsGroups;
    protected String editPermissionsUsers;
    private String labelsString;
    protected String newSpaceKey;
    protected String parentPageString;
    protected DraftManager draftManager;
    private boolean showDraftMessage = false;
    private boolean discardDraft = false;
    private String position;
    protected long targetId;
    protected CaptchaManager captchaManager;
    private boolean locationShowing = false;
    private boolean useDraft = false;
    private String title;
    private Draft draft;

    public boolean isUseDraft() {
        return this.useDraft;
    }

    public void setParentPageId(long parentPageId) {
        this.parentPageId = parentPageId;
        this.parentPage = null;
    }

    public long getParentPageId() {
        if (this.parentPageId == 0L && this.getParentPage() != null) {
            this.parentPageId = this.getParentPage().getId();
        }
        return this.parentPageId;
    }

    public Page getParentPage() {
        if (this.parentPage == null) {
            if (this.parentPageId != 0L) {
                this.parentPage = this.pageManager.getPage(this.parentPageId);
            } else if (StringUtils.isNotEmpty((String)this.getParentPageTitle())) {
                this.parentPage = this.pageManager.getPage(this.getParentPageSpaceKey(), this.getParentPageTitle());
            }
        }
        return this.parentPage;
    }

    protected List getPermissionTypes() {
        List permissionTypes = super.getPermissionTypes();
        this.addPermissionTypeTo("EDITSPACE", permissionTypes);
        return permissionTypes;
    }

    public void validate() {
        super.validate();
        if (this.isXHtml) {
            this.content = this.wysiwygConverter.convertXHtmlToWikiMarkup(this.getPageOrDummyPage(), this.wysiwygContent);
        }
        if (StringUtils.isNotEmpty((String)this.getParentPageString())) {
            this.setParentPageTitle(ActionHelper.extractPageTitle(this.parentPageString));
            if (ActionHelper.extractSpaceKey(this.parentPageString) != null) {
                this.setParentPageSpaceKey(ActionHelper.extractSpaceKey(this.parentPageString));
            } else {
                this.setParentPageSpaceKey(this.newSpaceKey);
            }
        }
        if (StringUtils.isNotEmpty((String)this.getParentPageString()) && this.getParentPage() == null) {
            this.addFieldError("parentPageString", this.getText("parent.page.doesnt.exist"));
        }
        if (StringUtils.isEmpty((String)this.getSpaceKey())) {
            this.addActionError(this.getText("AbstractPageAction.space.key.empty"));
        } else if (this.getSpace() == null) {
            this.addActionError(this.getText("space.doesnt.exist"));
        }
        int labelCount = LabelUtil.countLabels(this.getLabelsString());
        if (labelCount > 500) {
            this.addFieldError("labelsString", this.getText("labels.over.max", new Object[]{new Integer(labelCount), new Integer(500)}));
        } else {
            List labelNames = LabelUtil.split(this.getLabelsString());
            if (!LabelUtil.isValidLabelNames(labelNames)) {
                this.addFieldError("labelsString", this.getText("page.labels.invalid"));
            }
            if (!LabelUtil.isValidLabelLengths(labelNames)) {
                this.addFieldError("labelsString", this.getText("page.label.too.long", new Object[]{new Integer(255)}));
            }
        }
        if (StringUtils.isEmpty((String)this.getTitle())) {
            this.addFieldError("title", this.getText("page.title.empty"));
        } else {
            if (AbstractPage.hasInvalidTitleCharacters(this.getTitle())) {
                this.addFieldError("title", this.getText("page.title.invalid"));
            }
            if (!AbstractPage.isValidTitleLength(this.getTitle())) {
                this.addFieldError("title", this.getText("page.title.too.long"));
            }
        }
    }

    public void setShowDraftMessage(boolean showDraftMessage) {
        this.showDraftMessage = showDraftMessage;
    }

    protected abstract String getContentType();

    public String doDefault() throws Exception {
        String userName = this.getRemoteUser() == null ? null : this.getRemoteUser().getName();
        this.draft = this.draftManager.findDraft(String.valueOf(this.getPageId()), userName, this.getContentType());
        if (this.draft != null) {
            this.showDraftMessage = true;
            if (this.draft.isBlank()) {
                this.showDraftMessage = false;
            } else if (this.discardDraft) {
                this.draftManager.removeDraft(String.valueOf(this.getPageId()), userName, this.getContentType());
                this.showDraftMessage = false;
            } else if (this.useDraft) {
                if (StringUtils.isNotEmpty((String)this.draft.getTitle())) {
                    this.setTitle(this.draft.getTitle());
                }
                if (StringUtils.isNotEmpty((String)this.draft.getDraftSpaceKey())) {
                    this.setNewSpaceKey(this.draft.getDraftSpaceKey());
                }
                if (StringUtils.isNotEmpty((String)this.draft.getContent())) {
                    this.setContent(this.draft.getContent());
                }
                this.showDraftMessage = false;
            }
        }
        return super.doDefault();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getParentPageTitle() {
        if (StringUtils.isEmpty((String)this.parentPageTitle)) {
            this.parentPageTitle = ActionHelper.extractPageTitle(this.getParentPageString());
        }
        return this.parentPageTitle;
    }

    public void setParentPageTitle(String parentPageTitle) {
        this.parentPageTitle = parentPageTitle;
        this.parentPageId = 0L;
    }

    public String getParentPageSpaceKey() {
        if (StringUtils.isNotEmpty((String)this.parentPageSpaceKey)) {
            return this.parentPageSpaceKey;
        }
        return this.getSpaceKey();
    }

    public void setParentPageSpaceKey(String parentPageSpaceKey) {
        this.parentPageSpaceKey = parentPageSpaceKey;
        this.parentPage = null;
    }

    public ContentPermission getCurrentEditPermission() {
        return this.getPage().getContentPermission("Edit");
    }

    public ContentPermission getCurrentViewPermission() {
        return this.getPage().getContentPermission("View");
    }

    protected List createViewPermissions() {
        ArrayList<ContentPermission> viewContentPermissions = new ArrayList<ContentPermission>();
        viewContentPermissions.addAll(this.getGroupNamesAsPermissions(this.viewPermissionsGroups, "View"));
        viewContentPermissions.addAll(this.getUserNamesAsPermissions(this.viewPermissionsUsers, "View"));
        if (this.getRemoteUser() != null && this.isUserLockedOut(viewContentPermissions, this.getRemoteUser())) {
            viewContentPermissions.add(ContentPermission.createUserPermission("View", this.getRemoteUser().getName()));
        }
        return viewContentPermissions;
    }

    protected List createEditPermissions() {
        ArrayList<ContentPermission> editContentPermissions = new ArrayList<ContentPermission>();
        editContentPermissions.addAll(this.getGroupNamesAsPermissions(this.editPermissionsGroups, "Edit"));
        editContentPermissions.addAll(this.getUserNamesAsPermissions(this.editPermissionsUsers, "Edit"));
        if (this.getRemoteUser() != null && this.isUserLockedOut(editContentPermissions, this.getRemoteUser())) {
            editContentPermissions.add(ContentPermission.createUserPermission("Edit", this.getRemoteUser().getName()));
        }
        return editContentPermissions;
    }

    private boolean isUserLockedOut(Collection contentPermissions, User user) {
        if (user == null) {
            throw new IllegalArgumentException("This method can only be called a valid user.");
        }
        if (contentPermissions == null || contentPermissions.isEmpty()) {
            return false;
        }
        for (ContentPermission contentPermission : contentPermissions) {
            if (!contentPermission.isPermitted(user)) continue;
            return false;
        }
        return true;
    }

    private List getGroupNamesAsPermissions(String concatenatedGroupNames, String type) {
        ArrayList<ContentPermission> result = new ArrayList<ContentPermission>();
        String[] groupNames = GeneralUtil.splitCommaDelimitedString(concatenatedGroupNames);
        for (int i = 0; i < groupNames.length; ++i) {
            String groupName = groupNames[i];
            if (!StringUtils.isNotEmpty((String)groupName)) continue;
            result.add(ContentPermission.createGroupPermission(type, groupName));
        }
        return result;
    }

    private List getUserNamesAsPermissions(String concatenatedUserNames, String type) {
        ArrayList<ContentPermission> result = new ArrayList<ContentPermission>();
        String[] userNames = GeneralUtil.splitCommaDelimitedString(concatenatedUserNames);
        for (int i = 0; i < userNames.length; ++i) {
            String userName = userNames[i];
            if (!StringUtils.isNotEmpty((String)userName)) continue;
            result.add(ContentPermission.createUserPermission(type, userName));
        }
        return result;
    }

    public List getViewInheritedContentPermissionSets() {
        if (this.getParentPage() == null) {
            return Collections.EMPTY_LIST;
        }
        return this.contentPermissionManager.getContentPermissionSets(this.getParentPage(), "View");
    }

    public void setLabelsString(String labelsString) {
        this.labelsString = labelsString;
    }

    public String getLabelsString() {
        return this.labelsString;
    }

    public String getNewSpaceKey() {
        if (this.newSpaceKey == null) {
            return this.getSpaceKey();
        }
        return this.newSpaceKey;
    }

    public void setNewSpaceKey(String newSpaceKey) {
        this.newSpaceKey = newSpaceKey;
    }

    public String getParentPageString() {
        return this.parentPageString;
    }

    public void setParentPageString(String parentPageString) {
        this.parentPageString = parentPageString;
    }

    public void setDraftManager(DraftManager draftManager) {
        this.draftManager = draftManager;
    }

    public boolean isShowDraftMessage() {
        return this.showDraftMessage;
    }

    public void setDiscardDraft(boolean discardDraft) {
        this.discardDraft = discardDraft;
    }

    public void setUseDraft(boolean useDraft) {
        this.useDraft = useDraft;
    }

    public String getTitle() {
        return this.title;
    }

    public Draft getDraft() {
        return this.draft;
    }

    public String getCancelResult() {
        this.draftManager.removeDraft(String.valueOf(this.getPageId()), this.getRemoteUser() == null ? null : this.getRemoteUser().getName(), this.getContentType());
        return super.getCancelResult();
    }

    public Boolean getLocationShowing() {
        return this.locationShowing;
    }

    public void setLocationShowing(Boolean locationShowing) {
        this.locationShowing = locationShowing;
    }

    public Boolean getRestrictionsShowing() {
        return this.getUserInterfaceState().getRestrictionsShowing();
    }

    public void setRestrictionsShowing(Boolean restrictionsShowing) {
        this.getUserInterfaceState().setRestrictionsShowing(restrictionsShowing);
    }

    public Boolean getLabelsShowing() {
        if (this.getFieldErrors().get("labelsString") != null && ((Collection)this.getFieldErrors().get("labelsString")).size() > 0) {
            return Boolean.TRUE;
        }
        return this.getUserInterfaceState().getLabelsShowing();
    }

    public void setLabelsShowing(Boolean labelsShowing) {
        this.getUserInterfaceState().setLabelsShowing(labelsShowing);
    }

    public String getViewPermissionsGroups() {
        return this.viewPermissionsGroups;
    }

    public void setViewPermissionsGroups(String viewPermissionsGroups) {
        this.viewPermissionsGroups = viewPermissionsGroups;
    }

    public String getViewPermissionsUsers() {
        return this.viewPermissionsUsers;
    }

    public void setViewPermissionsUsers(String viewPermissionsUsers) {
        this.viewPermissionsUsers = viewPermissionsUsers;
    }

    public String getEditPermissionsGroups() {
        return this.editPermissionsGroups;
    }

    public void setEditPermissionsGroups(String editPermissionsGroups) {
        this.editPermissionsGroups = editPermissionsGroups;
    }

    public String getEditPermissionsUsers() {
        return this.editPermissionsUsers;
    }

    public void setEditPermissionsUsers(String editPermissionsUsers) {
        this.editPermissionsUsers = editPermissionsUsers;
    }

    protected void setPermissions(List permissions) {
        Iterator i = permissions.iterator();
        while (i.hasNext()) {
            this.getPage().addPermission((ContentPermission)i.next());
        }
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setTargetId(String targetId) {
        try {
            this.targetId = Long.parseLong(targetId);
        }
        catch (NumberFormatException e) {
            this.targetId = -1L;
        }
    }

    protected String getPosition() {
        return this.position;
    }

    protected long getTargetId() {
        return this.targetId;
    }

    public CaptchaManager getCaptchaManager() {
        return this.captchaManager;
    }

    public void setCaptchaManager(CaptchaManager captchaManager) {
        this.captchaManager = captchaManager;
    }
}

