/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.pages.actions;

import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.HeartbeatManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractCreateAndEditPageAction;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.util.DiffUtils;
import com.atlassian.confluence.util.LabelUtil;
import com.opensymphony.util.TextUtils;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractEditPageAction
extends AbstractCreateAndEditPageAction
implements PageAware {
    private static final Logger log = Logger.getLogger(AbstractEditPageAction.class);
    private boolean versionMismatch;
    private AbstractPage originalPage;
    private int originalVersion;
    private int conflictingVersion;
    private String oldContent;
    private String diff;
    private String overwrite;
    private String minorEdit;
    private String versionComment;
    private boolean conflictFound;
    private boolean mergeRequired;
    private HeartbeatManager heartbeatManager;
    private boolean viewConflict;

    public boolean isVersionMismatch() {
        return this.versionMismatch;
    }

    public void setVersionMismatch(boolean versionMismatch) {
        this.versionMismatch = versionMismatch;
    }

    public String getOldContent() {
        return this.oldContent;
    }

    public void setOldContent(String oldContent) {
        this.oldContent = oldContent;
    }

    public void setPage(AbstractPage page) {
        super.setPage(page);
        try {
            this.originalPage = (AbstractPage)page.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("Could not clone page?" + e), (Throwable)e);
        }
    }

    public String getContent() {
        if (this.content == null && this.getPage() != null) {
            this.content = this.getPage().getContent();
        }
        return this.content;
    }

    public String doDefault() throws Exception {
        this.setTitle(this.getPage().getTitle());
        String result = super.doDefault();
        this.setOriginalVersion(this.getPage().getVersion());
        this.setLabelsString(LabelUtil.convertToDelimitedString(this.getPage(), this.getRemoteUser(), this.labelManager));
        this.setNewSpaceKey(this.getPage().getSpaceKey());
        if (this.getDraft() != null) {
            int draftsOriginalVersion = this.getDraft().getPageVersion();
            if (this.draftManager.isMergeRequired(this.getDraft())) {
                String mergedContent = this.draftManager.getMergedContent(this.getDraft());
                if (mergedContent == null) {
                    if (this.isViewConflict()) {
                        this.setOriginalVersion(draftsOriginalVersion);
                        this.setContent(this.getDraft().getContent());
                        this.handleVersionConflict();
                        this.setShowDraftMessage(false);
                    }
                    this.conflictFound = true;
                } else {
                    this.mergeRequired = true;
                    if (this.isUseDraft()) {
                        this.setContent(mergedContent);
                    }
                }
            }
        }
        return result;
    }

    public String doEdit() throws Exception {
        if (StringUtils.isNotEmpty((String)this.back)) {
            return "input";
        }
        if (StringUtils.isNotEmpty((String)this.preview)) {
            this.updateXHtmlContent();
            this.setInPreview(true);
            return PREVIEW;
        }
        if (!this.handleVersionConflict()) {
            return "error";
        }
        return "success";
    }

    public String doSaveEditPageBean() {
        try {
            DefaultSaveContext saveContext = new DefaultSaveContext();
            AbstractPage page = this.getPage();
            boolean saveHistorical = false;
            if (this.isContentModified()) {
                page.setContent(this.content);
                page.setVersionComment(this.getVersionComment());
                if (TextUtils.stringSet((String)this.getMinorEdit())) {
                    saveContext.setMinorEdit(true);
                }
                saveHistorical = true;
            } else if (!this.getPage().getTitle().equals(this.originalPage.getTitle())) {
                page.setVersionComment(this.getVersionComment());
                saveHistorical = true;
            }
            LabelUtil.syncState(this.getLabelsString(), this.getLabelManager(), this.getRemoteUser(), page, true);
            if (saveHistorical) {
                this.pageManager.saveContentEntity(this.getPage(), this.originalPage, saveContext);
            }
            this.draftManager.removeDraft(String.valueOf(this.getPageId()), this.getRemoteUser() != null ? this.getRemoteUser().getName() : null, this.getContentType());
            this.heartbeatManager.stopActivity(this.getPageId() + this.getContentType(), this.getRemoteUser());
            return "success";
        }
        catch (Exception e) {
            LOG.error((Object)"An error occured while storing the requested page!", (Throwable)e);
            this.addActionError(this.getText("saving.the.page.failed"));
            return "error";
        }
    }

    protected boolean isContentModified() {
        String newContent = TextUtils.noNull((String)this.getContent()).trim();
        return this.getPage().getContent() != null && !this.getPage().getContent().trim().equals(newContent);
    }

    protected boolean isTitleModified() {
        if (TextUtils.stringSet((String)this.getTitle())) {
            return !this.getPage().getTitle().equals(this.getTitle());
        }
        return true;
    }

    private boolean handleVersionConflict() throws DifferentiationFailedException {
        String mergedContent;
        if (this.getOriginalVersion() == this.getPage().getVersion() || this.getConflictingVersion() == this.getPage().getVersion()) {
            return true;
        }
        AbstractPage originalPage = (AbstractPage)this.pageManager.getOtherVersion(this.getPage(), this.getOriginalVersion());
        if (originalPage != null && (mergedContent = DiffUtils.mergeChanges(originalPage.getContent(), this.getPage().getContent(), this.getContent())) != null) {
            this.setContent(mergedContent);
            return true;
        }
        this.versionMismatch = true;
        Page currentPage = new Page();
        currentPage.setContent(this.getContent());
        currentPage.setVersion(this.getPage().getVersion() + 1);
        this.diff = DiffUtils.generateDiff(this.getPage(), currentPage).getHtml();
        LOG.debug((Object)"Editing an outdated version of the page!");
        this.addActionError(this.getText("editing.an.outdated.page.version"));
        return false;
    }

    public AbstractPage getOriginalPage() {
        return (AbstractPage)this.pageManager.getOtherVersion(this.getPage(), this.getOriginalVersion());
    }

    public String getCancelResult() {
        this.heartbeatManager.stopActivity(this.getPageId() + this.getContentType(), this.getRemoteUser());
        return super.getCancelResult();
    }

    public int getOriginalVersion() {
        return this.originalVersion;
    }

    public void setOriginalVersion(int originalVersion) {
        this.originalVersion = originalVersion;
    }

    public int getConflictingVersion() {
        return this.conflictingVersion;
    }

    public void setConflictingVersion(int conflictingVersion) {
        this.conflictingVersion = conflictingVersion;
    }

    public String getDiff() {
        return this.diff;
    }

    public void setDiff(String diff) {
        this.diff = diff;
    }

    public String getOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(String overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isPermitted() {
        return this.isSpaceAdmin() || this.permissionManager.hasPermission(this.getRemoteUser(), Permission.EDIT, this.getPage()) && super.isPermitted();
    }

    public String getMinorEdit() {
        return this.minorEdit;
    }

    public void setMinorEdit(String minorEdit) {
        this.minorEdit = minorEdit;
    }

    public String getVersionComment() {
        return this.versionComment;
    }

    public void setVersionComment(String versionComment) {
        this.versionComment = TextUtils.stringSet((String)versionComment) && versionComment.trim().length() > 0 ? versionComment : null;
    }

    public boolean isConflictFound() {
        return this.conflictFound;
    }

    public boolean isMergeRequired() {
        return this.mergeRequired;
    }

    public void setViewConflict(boolean viewConflict) {
        this.viewConflict = viewConflict;
    }

    public boolean isViewConflict() {
        return this.viewConflict;
    }

    protected String getContentType() {
        return this.getPage().getType();
    }

    public void setHeartbeatManager(HeartbeatManager heartbeatManager) {
        this.heartbeatManager = heartbeatManager;
    }
}

